/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.shared.GridNodeServer;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.grid.web.servlet.NodeW3CStatusServlet;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.log.LoggingManager;

public class SelfRegisteringRemote {
    private static final Logger LOG = Logger.getLogger(SelfRegisteringRemote.class.getName());
    private final RegistrationRequest registrationRequest;
    private final HttpClient.Factory httpClientFactory;
    private final Map<String, Class<? extends Servlet>> nodeServlets;
    private boolean hasId;
    private GridNodeServer server;

    public SelfRegisteringRemote(GridNodeConfiguration configuration) {
        this(RegistrationRequest.build(configuration, null, null));
    }

    public SelfRegisteringRemote(RegistrationRequest request) {
        this.registrationRequest = request;
        this.httpClientFactory = HttpClient.Factory.createDefault();
        this.nodeServlets = new HashMap<String, Class<? extends Servlet>>();
        this.registrationRequest.validate();
        this.nodeServlets.put("/status", NodeW3CStatusServlet.class);
        this.nodeServlets.put("/wd/hub/status", NodeW3CStatusServlet.class);
        if (!this.registrationRequest.getConfiguration().isWithOutServlet(ResourceServlet.class)) {
            this.nodeServlets.put("/resources/*", ResourceServlet.class);
        }
        if (!this.registrationRequest.getConfiguration().isWithOutServlet(DisplayHelpServlet.class)) {
            this.nodeServlets.put("/*", DisplayHelpServlet.class);
        }
        this.addExtraServlets(this.registrationRequest.getConfiguration().servlets);
    }

    public URL getRemoteURL() {
        String host = this.registrationRequest.getConfiguration().host;
        Integer port = this.registrationRequest.getConfiguration().port;
        String url = "http://" + host + ":" + port;
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new GridConfigurationException("error building the node url " + e.getMessage(), e);
        }
    }

    public void setRemoteServer(GridNodeServer server) {
        this.server = server;
    }

    public boolean startRemoteServer() throws Exception {
        if (this.server == null) {
            throw new GridConfigurationException("no server set to register to the hub");
        }
        this.server.setExtraServlets(this.nodeServlets);
        return this.server.boot();
    }

    public void stopRemoteServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void deleteAllBrowsers() {
        this.registrationRequest.getConfiguration().capabilities.clear();
    }

    public void addBrowser(DesiredCapabilities cap, int instances) {
        String s = cap.getBrowserName();
        if (s == null || "".equals(s)) {
            throw new InvalidParameterException(cap + " does seems to be a valid browser.");
        }
        if (cap.getPlatform() == null) {
            cap.setPlatform(Platform.getCurrent());
        }
        cap.setCapability("maxInstances", (Object)instances);
        this.registrationRequest.getConfiguration().capabilities.add((MutableCapabilities)cap);
        this.registrationRequest.getConfiguration().fixUpCapabilities();
    }

    public void sendRegistrationRequest() {
        this.registerToHub(false);
    }

    public void startRegistrationProcess() {
        this.fixUpId();
        LOG.fine("Using the json request : " + this.registrationRequest.toJson());
        Boolean register = this.registrationRequest.getConfiguration().register;
        if (register == null) {
            register = false;
        }
        if (!register.booleanValue()) {
            LOG.info("No registration sent ( register = false )");
        } else {
            int registerCycleInterval;
            int n = registerCycleInterval = this.registrationRequest.getConfiguration().registerCycle != null ? this.registrationRequest.getConfiguration().registerCycle : 0;
            if (registerCycleInterval > 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean first = true;
                        LOG.info("Starting auto registration thread. Will try to register every " + registerCycleInterval + " ms.");
                        while (true) {
                            try {
                                boolean checkForPresence = true;
                                if (first) {
                                    first = false;
                                    checkForPresence = false;
                                }
                                SelfRegisteringRemote.this.registerToHub(checkForPresence);
                            }
                            catch (GridException e) {
                                LOG.info("Couldn't register this node: " + e.getMessage());
                            }
                            try {
                                Thread.sleep(registerCycleInterval);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            LoggingManager.perSessionLogHandler().clearThreadTempLogs();
                        }
                    }
                }).start();
            } else {
                this.registerToHub(false);
            }
        }
        LoggingManager.perSessionLogHandler().clearThreadTempLogs();
    }

    public void setTimeout(int timeout, int cycle) {
        this.registrationRequest.getConfiguration().timeout = timeout;
        this.registrationRequest.getConfiguration().cleanUpCycle = cycle;
    }

    public void setMaxConcurrent(int max) {
        this.registrationRequest.getConfiguration().maxSession = max;
    }

    public GridNodeConfiguration getConfiguration() {
        return this.registrationRequest.getConfiguration();
    }

    protected GridNodeServer getServer() {
        return this.server;
    }

    protected Map<String, Class<? extends Servlet>> getNodeServlets() {
        return this.nodeServlets;
    }

    private void registerToHub(boolean checkPresenceFirst) {
        if (!checkPresenceFirst || !this.isAlreadyRegistered(this.registrationRequest)) {
            String tmp = "http://" + this.registrationRequest.getConfiguration().getHubHost() + ":" + this.registrationRequest.getConfiguration().getHubPort() + "/grid/register";
            try {
                URL registration = new URL(tmp);
                LOG.info("Registering the node to the hub: " + registration);
                HttpRequest request = new HttpRequest(HttpMethod.POST, registration.toExternalForm());
                this.updateConfigWithRealPort();
                String json = new Json().toJson((Object)this.registrationRequest);
                request.setContent(json.getBytes(StandardCharsets.UTF_8));
                HttpClient client = this.httpClientFactory.createClient(registration);
                HttpResponse response = client.execute(request);
                if (response.getStatus() != 200) {
                    throw new GridException(String.format("The hub responded with %s", response.getStatus()));
                }
                try {
                    LOG.info("Updating the node configuration from the hub");
                    GridHubConfiguration hubConfiguration = this.getHubConfiguration();
                    if (hubConfiguration.timeout != null && hubConfiguration.timeout >= 0) {
                        this.registrationRequest.getConfiguration().timeout = hubConfiguration.timeout;
                    }
                    if (hubConfiguration.browserTimeout != null && hubConfiguration.browserTimeout >= 0) {
                        this.registrationRequest.getConfiguration().browserTimeout = hubConfiguration.browserTimeout;
                    }
                }
                catch (Exception e) {
                    LOG.warning("error getting the parameters from the hub. The node may end up with wrong timeouts." + e.getMessage());
                }
                LOG.info("The node is registered to the hub and ready to use");
            }
            catch (Exception e) {
                throw new GridException("Error sending the registration request: " + e.getMessage());
            }
        }
        LOG.fine("The node is already present on the hub. Skipping registration.");
    }

    private void addExtraServlets(List<String> servlets) {
        if (servlets == null || servlets.size() == 0) {
            return;
        }
        for (String s : servlets) {
            Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
            if (servletClass == null) continue;
            String path = "/extra/" + servletClass.getSimpleName() + "/*";
            LOG.info("binding " + servletClass.getCanonicalName() + " to " + path);
            this.nodeServlets.put(path, servletClass);
        }
    }

    private void fixUpId() {
        if (this.hasId) {
            return;
        }
        if (this.registrationRequest.getConfiguration().id == null || this.registrationRequest.getConfiguration().id.isEmpty()) {
            this.registrationRequest.getConfiguration().id = this.registrationRequest.getConfiguration().getRemoteHost();
        }
        this.hasId = true;
    }

    void updateConfigWithRealPort() throws MalformedURLException {
        if (this.registrationRequest.getConfiguration().port != 0) {
            return;
        }
        this.registrationRequest.getConfiguration().port = this.server.getRealPort();
    }

    private GridHubConfiguration getHubConfiguration() throws Exception {
        String hubApi = "http://" + this.registrationRequest.getConfiguration().getHubHost() + ":" + this.registrationRequest.getConfiguration().getHubPort() + "/grid/api/hub";
        URL api = new URL(hubApi);
        HttpClient client = this.httpClientFactory.createClient(api);
        String url = api.toExternalForm();
        HttpRequest request = new HttpRequest(HttpMethod.GET, url);
        HttpResponse response = client.execute(request);
        return GridHubConfiguration.loadFromJSON(SelfRegisteringRemote.extractObject(response));
    }

    private boolean isAlreadyRegistered(RegistrationRequest node) {
        try {
            HttpRequest request;
            HttpResponse response;
            String tmp = "http://" + node.getConfiguration().getHubHost() + ":" + node.getConfiguration().getHubPort() + "/grid/api/proxy";
            URL api = new URL(tmp);
            HttpClient client = this.httpClientFactory.createClient(api);
            String id = node.getConfiguration().id;
            if (id == null) {
                id = node.getConfiguration().getRemoteHost();
            }
            if ((response = client.execute(request = new HttpRequest(HttpMethod.GET, api.toExternalForm() + "?id=" + id))).getStatus() != 200) {
                throw new GridException(String.format("The hub responded with %s", response.getStatus()));
            }
            JsonObject o = SelfRegisteringRemote.extractObject(response);
            return o.get("success").getAsBoolean();
        }
        catch (Exception e) {
            throw new GridException("The hub is down or not responding: " + e.getMessage());
        }
    }

    private static JsonObject extractObject(HttpResponse resp) {
        return new JsonParser().parse(resp.getContentString()).getAsJsonObject();
    }
}

