/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.selenium.MutableCapabilities;

public class RegistrationRequest {
    public static final String MAX_INSTANCES = "maxInstances";
    public static final String SELENIUM_PROTOCOL = "seleniumProtocol";
    public static final String PATH = "path";
    @SerializedName(value="class")
    @Expose(deserialize=false)
    private final String clazz = RegistrationRequest.class.getCanonicalName();
    @Expose
    private String name;
    @Expose
    private String description;
    @Expose
    private GridNodeConfiguration configuration;

    public RegistrationRequest() {
        this(new GridNodeConfiguration());
    }

    public RegistrationRequest(GridNodeConfiguration configuration) {
        this(configuration, null, null);
    }

    public RegistrationRequest(GridNodeConfiguration configuration, String name) {
        this(configuration, name, null);
    }

    public RegistrationRequest(GridNodeConfiguration configuration, String name, String description) {
        this.configuration = configuration == null ? new GridNodeConfiguration() : configuration;
        this.name = name;
        this.description = description;
        this.configuration.fixUpHost();
        this.configuration.fixUpCapabilities();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public GridNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<String, Object> toJson() {
        TreeMap<String, Object> json = new TreeMap<String, Object>();
        json.put("class", this.getClass());
        json.put("name", this.getName());
        json.put("description", this.getDescription());
        json.put("configuration", this.getConfiguration());
        return json;
    }

    public static RegistrationRequest fromJson(JsonObject json) throws JsonSyntaxException {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(new TypeToken<List<MutableCapabilities>>(){}.getType(), (Object)new GridNodeConfiguration.CollectionOfDesiredCapabilitiesDeSerializer());
        RegistrationRequest request = (RegistrationRequest)builder.excludeFieldsWithoutExposeAnnotation().create().fromJson((JsonElement)json, RegistrationRequest.class);
        return request;
    }

    public static RegistrationRequest fromJson(String json) throws JsonSyntaxException {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(new TypeToken<List<MutableCapabilities>>(){}.getType(), (Object)new GridNodeConfiguration.CollectionOfDesiredCapabilitiesDeSerializer());
        RegistrationRequest request = (RegistrationRequest)builder.excludeFieldsWithoutExposeAnnotation().create().fromJson(json, RegistrationRequest.class);
        return request;
    }

    public static RegistrationRequest build() {
        return RegistrationRequest.build(new GridNodeConfiguration(), null, null);
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration) {
        return RegistrationRequest.build(configuration, null, null);
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration, String name) {
        return RegistrationRequest.build(configuration, name, null);
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration, String name, String description) {
        RegistrationRequest pendingRequest = new RegistrationRequest(configuration, name, description);
        GridNodeConfiguration pendingConfiguration = pendingRequest.configuration;
        if (pendingConfiguration.nodeConfigFile != null) {
            pendingRequest.configuration = GridNodeConfiguration.loadFromJSON(pendingConfiguration.nodeConfigFile);
        }
        pendingRequest.configuration.merge(pendingConfiguration);
        if (pendingConfiguration.host != null) {
            pendingRequest.configuration.host = pendingConfiguration.host;
        }
        if (pendingConfiguration.port != null) {
            pendingRequest.configuration.port = pendingConfiguration.port;
        }
        pendingRequest.configuration.fixUpHost();
        pendingRequest.configuration.fixUpCapabilities();
        pendingRequest.configuration.dropCapabilitiesThatDoesNotMatchCurrentPlatform();
        return pendingRequest;
    }

    public void validate() throws GridConfigurationException {
        try {
            this.configuration.getHubHost();
            this.configuration.getHubPort();
        }
        catch (RuntimeException e) {
            throw new GridConfigurationException(e.getMessage());
        }
    }
}

