/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.beust.jcommander.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.internal.utils.configuration.converters.CustomConverter;

public class GridConfiguration
extends StandaloneConfiguration {
    @Parameter(names={"-cleanUpCycle"}, description="<Integer> in ms : specifies how often the hub will poll running proxies for timed-out (i.e. hung) threads. Must also specify \"timeout\" option")
    public Integer cleanUpCycle;
    @Parameter(names={"-custom"}, description="<String> : NOT RECOMMENDED--may be deprecated to encourage proper servlet customization. Comma separated key=value pairs for custom grid extensions. example: -custom myParamA=Value1,myParamB=Value2", converter=CustomConverter.class)
    public Map<String, String> custom = new HashMap<String, String>();
    @Parameter(names={"-host"}, description="<String> IP or hostname : usually determined automatically. Most commonly useful in exotic network configurations (e.g. network with VPN)")
    public String host;
    @Parameter(names={"-maxSession"}, description="<Integer> max number of tests that can run at the same time on the node, irrespective of the browser used")
    public Integer maxSession = 1;
    @Parameter(names={"-servlet", "-servlets"}, description="<String> : list of extra servlets this hub will display. Allows to present custom view of the hub for monitoring and management purposes. Specify multiple on the command line: -servlet tld.company.ServletA -servlet tld.company.ServletB. The servlet must exist in the path: /grid/admin/ServletA /grid/admin/ServletB")
    public List<String> servlets;

    public void merge(GridConfiguration other) {
        super.merge(other);
        if (other.cleanUpCycle != null) {
            this.cleanUpCycle = other.cleanUpCycle;
        }
        this.custom.putAll(other.custom);
        if (other.maxSession != 1) {
            this.maxSession = other.maxSession;
        }
        if (other.servlets != null) {
            this.servlets = other.servlets;
        }
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "cleanUpCycle", this.cleanUpCycle));
        sb.append((CharSequence)this.toString(format, "custom", this.custom));
        sb.append((CharSequence)this.toString(format, "host", this.host));
        sb.append((CharSequence)this.toString(format, "maxSession", this.maxSession));
        sb.append((CharSequence)this.toString(format, "servlets", this.servlets));
        return sb.toString();
    }
}

