/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.beust.jcommander.Parameter;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.List;

public class StandaloneConfiguration {
    @Parameter(names={"-browserTimeout"}, description="<Integer> in seconds : number of seconds a browser session is allowed to hang (0 means indefinite) while a WebDriver command is running (example: driver.get(url)). If the timeout is reached while a WebDriver command is still processing, the session will quit. Minimum value is 60. Default is 0")
    public Integer browserTimeout;
    @Parameter(names={"-debug"}, description="<Boolean> : enables LogLevel.FINE. Default is false (if omitted)")
    public boolean debug;
    @Parameter(names={"--help", "-help", "-h"}, help=true, hidden=true, description="Displays this help")
    public boolean help;
    @Parameter(names={"-jettyThreads"}, hidden=true)
    public Integer jettyThreads;
    @Parameter(names={"-log"}, description="<String> filename : the filename to use for logging. If omitted, will log to STDOUT")
    public String log;
    @Parameter(names={"-logLongForm"}, description="<Boolean> : if specified, all log statements (including to log file from \"log\" parameter) will include the Thread ID")
    public boolean logLongForm;
    @Parameter(names={"-port"}, description="<Integer> : the port number the server will use. Defaults to [4444]. When \"role\" is a set to [node], default is [5555]")
    public Integer port;
    @Parameter(names={"-role"}, description="<String> options are [hub], [node], or [standalone] : Default is [standalone]")
    public String role = "standalone";
    @Parameter(names={"-timeout", "-sessionTimeout"}, description="<Integer> in seconds : Specifies the timeout before the hub automatically kills a session that hasn't had any activity in the last X seconds. The test slot will then be released for another test to use. This is typically used to take care of client crashes. For grid hub/node roles, cleanUpCycle must also be set. Default is 1800 (30 minutes)")
    public Integer timeout = 1800;
    @Parameter(names={"-avoidProxy"}, description="DO NOT USE. Hack to allow selenium 3.0 server run in SauceLabs")
    private Boolean avoidProxy;

    public void merge(StandaloneConfiguration other) {
        if (other.browserTimeout != null) {
            this.browserTimeout = other.browserTimeout;
        }
        if (other.jettyThreads != null) {
            this.jettyThreads = other.jettyThreads;
        }
        if (other.timeout != 1800) {
            this.timeout = other.timeout;
        }
    }

    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.toString(format, "browserTimeout", this.browserTimeout));
        sb.append((CharSequence)this.toString(format, "debug", this.debug));
        sb.append((CharSequence)this.toString(format, "help", this.help));
        sb.append((CharSequence)this.toString(format, "jettyThreads", this.jettyThreads));
        sb.append((CharSequence)this.toString(format, "log", this.log));
        sb.append((CharSequence)this.toString(format, "logLongForm", this.logLongForm));
        sb.append((CharSequence)this.toString(format, "port", this.port));
        sb.append((CharSequence)this.toString(format, "role", this.role));
        sb.append((CharSequence)this.toString(format, "timeout", this.timeout));
        return sb.toString();
    }

    public String toString() {
        return this.toString(" -%1$s %2$s");
    }

    public StringBuilder toString(String format, String name, Object value) {
        StringBuilder sb = new StringBuilder();
        List<Object> iterator = value instanceof List ? (List<Object>)value : Arrays.asList(value);
        for (Object e : iterator) {
            if (value == null) continue;
            sb.append(String.format(format, name, value));
        }
        return sb;
    }

    public JsonElement toJson() {
        GsonBuilder builder = new GsonBuilder();
        this.addJsonTypeAdapter(builder);
        return builder.create().toJsonTree((Object)this);
    }

    protected void addJsonTypeAdapter(GsonBuilder builder) {
    }
}

