/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.common.JSONConfigurationUtils;
import org.openqa.grid.common.SeleniumProtocol;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.selenium.Platform;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.JsonToBeanConverter;

public class RegistrationRequest {
    private String name;
    private String description;
    private GridRole role;
    private List<DesiredCapabilities> capabilities = new ArrayList<DesiredCapabilities>();
    private GridNodeConfiguration configuration = new GridNodeConfiguration();
    public static final String MAX_INSTANCES = "maxInstances";
    public static final String SELENIUM_PROTOCOL = "seleniumProtocol";
    public static final String PATH = "path";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<DesiredCapabilities> getCapabilities() {
        return this.capabilities;
    }

    public void addDesiredCapability(DesiredCapabilities c) {
        this.capabilities.add(c);
    }

    public void addDesiredCapability(Map<String, Object> c) {
        this.capabilities.add(new DesiredCapabilities(c));
    }

    public void setCapabilities(List<DesiredCapabilities> capabilities) {
        this.capabilities = capabilities;
    }

    public GridNodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GridNodeConfiguration configuration) {
        this.configuration = configuration;
    }

    public String toJSON() {
        return new Gson().toJson((JsonElement)this.getAssociatedJSON());
    }

    public JsonObject getAssociatedJSON() {
        JsonObject res = new JsonObject();
        res.addProperty("class", this.getClass().getCanonicalName());
        res.addProperty("id", this.configuration.id);
        res.addProperty("name", this.name);
        res.addProperty("description", this.description);
        res.add("configuration", this.configuration.toJson());
        JsonArray caps = new JsonArray();
        for (DesiredCapabilities c : this.capabilities) {
            caps.add(new Gson().toJsonTree((Object)c.asMap()));
        }
        res.add("capabilities", (JsonElement)caps);
        return res;
    }

    public static RegistrationRequest getNewInstance(String json) throws JsonSyntaxException {
        RegistrationRequest request = new RegistrationRequest();
        JsonObject o = new JsonParser().parse(json).getAsJsonObject();
        if (o.has("name")) {
            request.setName(o.get("name").getAsString());
        }
        if (o.has("description")) {
            request.setDescription(o.get("description").getAsString());
        }
        JsonObject config = o.get("configuration").getAsJsonObject();
        GridNodeConfiguration configuration = GridNodeConfiguration.loadFromJSON(config);
        request.setConfiguration(configuration);
        if (o.has("id")) {
            request.configuration.id = o.get("id").getAsString();
        }
        JsonArray capabilities = o.get("capabilities").getAsJsonArray();
        for (int i = 0; i < capabilities.size(); ++i) {
            DesiredCapabilities cap = (DesiredCapabilities)new JsonToBeanConverter().convert(DesiredCapabilities.class, (Object)capabilities.get(i));
            request.capabilities.add(cap);
        }
        return request;
    }

    public String getRemoteProxyClass() {
        return this.configuration.proxy;
    }

    public static RegistrationRequest build(GridNodeConfiguration configuration) {
        RegistrationRequest res = RegistrationRequest.newFromJSON("defaults/DefaultNodeWebDriver.json");
        if (configuration.nodeConfigFile != null) {
            res.loadFromJSON(configuration.nodeConfigFile);
        }
        res.configuration.merge(configuration);
        if (configuration.host != null) {
            res.configuration.host = configuration.host;
        }
        res.configuration.host = RegistrationRequest.guessHost(res.configuration.host);
        if (configuration.port != null) {
            res.configuration.port = configuration.port;
        }
        res.role = GridRole.get(configuration.role);
        res.addPlatformInfoToCapabilities();
        if (configuration.browser.size() > 0) {
            res.capabilities = configuration.browser;
        }
        for (DesiredCapabilities cap : res.capabilities) {
            if (cap.getCapability(SELENIUM_PROTOCOL) != null) continue;
            cap.setCapability(SELENIUM_PROTOCOL, SeleniumProtocol.WebDriver.toString());
        }
        return res;
    }

    private void addPlatformInfoToCapabilities() {
        Platform current = Platform.getCurrent();
        for (DesiredCapabilities cap : this.capabilities) {
            if (cap.getPlatform() != null) continue;
            cap.setPlatform(current);
        }
    }

    private static String guessHost(String host) {
        if (host == null || "ip".equalsIgnoreCase(host)) {
            NetworkUtils util = new NetworkUtils();
            return util.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        }
        if ("host".equalsIgnoreCase(host)) {
            NetworkUtils util = new NetworkUtils();
            return util.getIp4NonLoopbackAddressOfThisMachine().getHostName();
        }
        return host;
    }

    public void loadFromJSON(String resource) {
        try {
            JsonObject base = JSONConfigurationUtils.loadJSON(resource);
            if (base.has("capabilities")) {
                this.capabilities = new ArrayList<DesiredCapabilities>();
                JsonArray a = base.get("capabilities").getAsJsonArray();
                for (int i = 0; i < a.size(); ++i) {
                    DesiredCapabilities c = (DesiredCapabilities)new JsonToBeanConverter().convert(DesiredCapabilities.class, (Object)a.get(i));
                    this.capabilities.add(c);
                }
                this.addPlatformInfoToCapabilities();
            }
            GridNodeConfiguration loadedConfiguration = (GridNodeConfiguration)new Gson().fromJson(base.get("configuration"), GridNodeConfiguration.class);
            this.configuration.merge(loadedConfiguration);
            if (loadedConfiguration.host != null) {
                this.configuration.host = loadedConfiguration.host;
            }
            if (loadedConfiguration.port != null) {
                this.configuration.port = loadedConfiguration.port;
            }
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public static RegistrationRequest newFromJSON(String resource) {
        RegistrationRequest req = new RegistrationRequest();
        req.loadFromJSON(resource);
        return req;
    }

    public GridRole getRole() {
        return this.role;
    }

    public void setRole(GridRole role) {
        this.role = role;
    }

    public void validate() throws GridConfigurationException {
        String hub = this.configuration.getHubHost();
        Integer port = this.configuration.getHubPort();
        if (hub == null || port == null) {
            throw new GridConfigurationException("You need to specify a hub to register to using -hubHost X -hubPort 5555.The specified config was -hubHost" + hub + " -hubPort " + port);
        }
    }
}

