/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BrowserResponseSequencer {
    static Logger log = Logger.getLogger(BrowserResponseSequencer.class.getName());
    int num = 0;
    final Lock lock;
    final Condition numIncreased;
    final String uniqueId;

    public BrowserResponseSequencer(String uniqueId) {
        this.uniqueId = uniqueId;
        this.lock = new ReentrantLock();
        this.numIncreased = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseNum() {
        this.lock.lock();
        try {
            ++this.num;
            this.numIncreased.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitUntilNumIsAtLeast(int expected) {
        this.lock.lock();
        try {
            while (true) {
                if (this.num >= expected) {
                    return;
                }
                log.fine("Waiting " + this.uniqueId + ", expected sequence number " + expected + ", was " + this.num + ".");
                boolean timedOut = false;
                try {
                    timedOut = !this.numIncreased.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    log.log(Level.FINE, "interrupted", e);
                }
                if (!timedOut) continue;
                log.warning(this.uniqueId + " expected sequence number " + expected + ", was " + this.num + ".  Continuing anyway");
                ++this.num;
                this.numIncreased.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.uniqueId + ": " + this.num;
    }
}

