/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler.interactions.touch;

import java.util.Map;
import org.openqa.selenium.HasTouchScreen;
import org.openqa.selenium.TouchScreen;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebElementHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

public class LongPressOnElement
extends WebElementHandler
implements JsonParametersAware {
    private static final String ELEMENT = "element";
    private String elementId;

    public LongPressOnElement(Session session) {
        super(session);
    }

    @Override
    public ResultType call() throws Exception {
        TouchScreen touchScreen = ((HasTouchScreen)this.getDriver()).getTouch();
        WebElement element = this.getKnownElements().get(this.elementId);
        Coordinates elementLocation = ((Locatable)element).getCoordinates();
        touchScreen.longPress(elementLocation);
        return ResultType.SUCCESS;
    }

    public String toString() {
        return String.format("[Long press: %s]", this.elementId);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.elementId = (String)allParameters.get(ELEMENT);
    }
}

