/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.exception.NewSessionException;
import org.openqa.grid.web.servlet.handler.RequestType;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;
import org.openqa.grid.web.utils.BrowserNameUtils;

public class LegacySeleniumRequest
extends SeleniumBasedRequest {
    public LegacySeleniumRequest(HttpServletRequest httpServletRequest, Registry registry) {
        super(httpServletRequest, registry);
    }

    @Override
    public RequestType extractRequestType() {
        if (this.getBody().contains("cmd=getNewBrowserSession")) {
            return RequestType.START_SESSION;
        }
        if (this.getBody().contains("cmd=testComplete")) {
            return RequestType.STOP_SESSION;
        }
        return RequestType.REGULAR;
    }

    @Override
    public ExternalSessionKey extractSession() {
        String[] pieces;
        if (this.getRequestType() == RequestType.START_SESSION) {
            throw new IllegalAccessError("Cannot call that method of a new session request.");
        }
        String command = this.getBody();
        for (String piece : pieces = command.split("&")) {
            ExternalSessionKey externalSessionKey = ExternalSessionKey.fromSe1Request(piece);
            if (externalSessionKey == null) continue;
            return externalSessionKey;
        }
        return null;
    }

    @Override
    public Map<String, Object> extractDesiredCapability() {
        String[] pieces;
        if (this.getRequestType() != RequestType.START_SESSION) {
            throw new Error("the desired capability is only present in the new session requests.");
        }
        for (String piece : pieces = this.getBody().split("&")) {
            try {
                piece = URLDecoder.decode(piece, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            if (!piece.startsWith("1=")) continue;
            String envt = piece.replace("1=", "");
            HashMap<String, Object> cap = new HashMap<String, Object>();
            if (this.getRegistry().getConfiguration().getGrid1Mapping().containsKey(envt)) {
                cap.put("browserName", envt);
            } else {
                cap.putAll(BrowserNameUtils.parseGrid2Environment(envt));
            }
            return cap;
        }
        throw new RuntimeException("Error");
    }

    @Override
    public String getNewSessionRequestedCapability(TestSession session) {
        try {
            String body = this.getBody();
            String[] pieces = body.split("&");
            StringBuilder builder = new StringBuilder();
            for (String piece : pieces) {
                if (piece.startsWith("1=")) {
                    piece = URLDecoder.decode(piece, "UTF-8");
                    String[] parts = piece.split("1=");
                    piece = this.getRegistry().getConfiguration().getGrid1Mapping().containsKey(parts[1]) ? String.format("1=%s", URLEncoder.encode(BrowserNameUtils.lookupGrid1Environment(parts[1], this.getRegistry()), "UTF-8")) : (String)BrowserNameUtils.parseGrid2Environment(piece).get("browserName");
                }
                builder.append(piece).append("&");
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NewSessionException("Error with the request ");
        }
    }
}

