/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http;

import java.io.IOException;
import java.io.OutputStream;
import org.openqa.jetty.http.BufferedOutputStream;
import org.openqa.jetty.http.HttpMessage;

public class ChunkingOutputStream
extends BufferedOutputStream
implements HttpMessage.HeaderWriter {
    static final byte[] __CRLF = new byte[]{13, 10};
    static final byte[] __CHUNK_EOF = new byte[]{48, 13, 10, 13, 10};
    static final int __CHUNK_RESERVE = 8;
    static final int __EOF_RESERVE = 8;
    private boolean _chunking;
    private boolean _complete;
    private boolean _completed;

    public ChunkingOutputStream(OutputStream outputStream, int bufferSize, int headerReserve) {
        this(outputStream, bufferSize, headerReserve, true);
    }

    public ChunkingOutputStream(OutputStream outputStream, int bufferSize, int headerReserve, boolean chunking) {
        super(outputStream, bufferSize, headerReserve, 8, 8);
        this._chunking = chunking;
        this.setBypassBuffer(true);
        this.setFixed(true);
    }

    public boolean isChunking() {
        return this._chunking;
    }

    public void setChunking(boolean chunking) {
        this._chunking = chunking;
    }

    @Override
    public void close() throws IOException {
        this._complete = true;
        this.flush();
    }

    @Override
    public void resetStream() {
        this._complete = false;
        this._completed = false;
        this._chunking = true;
        super.resetStream();
    }

    @Override
    protected void wrapBuffer() throws IOException {
        if (this._chunking && this.size() > 0) {
            this.prewrite(__CRLF, 0, __CRLF.length);
            for (int size = this.size(); size > 0; size /= 16) {
                int d = size % 16;
                if (d <= 9) {
                    this.prewrite(48 + d);
                    continue;
                }
                this.prewrite(87 + d);
            }
            this.postwrite(__CRLF, 0, __CRLF.length);
        }
        if (this._complete && !this._completed) {
            this._completed = true;
            if (this._chunking) {
                this.postwrite(__CHUNK_EOF, 0, __CHUNK_EOF.length);
            }
        }
    }

    @Override
    protected void bypassWrite(byte[] b, int offset, int length) throws IOException {
        int i = 9;
        this._buf[10] = 10;
        this._buf[9] = 13;
        for (int chunk = length; chunk > 0; chunk /= 16) {
            int d = chunk % 16;
            this._buf[--i] = d <= 9 ? (byte)(48 + d) : (byte)(87 + d);
        }
        if (this._chunking) {
            this._out.write(this._buf, i, 10 - i + 1);
        }
        this._out.write(b, offset, length);
        if (this._chunking) {
            this._out.write(__CRLF, 0, __CRLF.length);
        }
        this._out.flush();
    }
}

