/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.log;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.openqa.selenium.server.log.PerSessionLogHandler;
import org.openqa.selenium.server.log.SessionLogsToFileRepository;

public class DefaultPerSessionLogHandler
extends PerSessionLogHandler {
    private final Map<String, List<LogRecord>> perSessionRecords;
    private final Map<ThreadKey, List<LogRecord>> perThreadTempRecords;
    private final Formatter formatter;
    private Map<ThreadKey, String> threadToSessionMap;
    private Map<String, ThreadKey> sessionToThreadMap;
    private SessionLogsToFileRepository logFileRepository;
    private int capacity;

    public DefaultPerSessionLogHandler(int capacity, Level minimumLevel, Formatter formatter) {
        this.capacity = capacity;
        this.formatter = formatter;
        this.perSessionRecords = new HashMap<String, List<LogRecord>>();
        this.perThreadTempRecords = new HashMap<ThreadKey, List<LogRecord>>();
        this.threadToSessionMap = new HashMap<ThreadKey, String>();
        this.sessionToThreadMap = new HashMap<String, ThreadKey>();
        this.logFileRepository = new SessionLogsToFileRepository();
    }

    public synchronized void publish(LogRecord record) {
        ThreadKey threadId = new ThreadKey();
        String sessionId = this.threadToSessionMap.get(threadId);
        if (sessionId != null) {
            List<LogRecord> records = this.perSessionRecords.get(sessionId);
            if (records == null) {
                records = new ArrayList<LogRecord>();
            }
            records.add(record);
            this.perSessionRecords.put(sessionId, records);
            if (records.size() > this.capacity) {
                this.perSessionRecords.put(sessionId, new ArrayList());
                try {
                    this.logFileRepository.flushRecordsToLogFile(sessionId, records);
                    records.clear();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            List<LogRecord> records = this.perThreadTempRecords.get(threadId);
            if (records == null) {
                records = new ArrayList<LogRecord>();
                this.perThreadTempRecords.put(threadId, records);
            }
            records.add(record);
        }
    }

    public void flush() {
    }

    public synchronized void close() throws SecurityException {
        this.perSessionRecords.clear();
        this.perThreadTempRecords.clear();
    }

    private LogRecord[] records(String sessionId) throws IOException {
        List<LogRecord> logFileRecords = this.logFileRepository.getLogRecords(sessionId);
        List<LogRecord> records = this.perSessionRecords.get(sessionId);
        if (records != null) {
            logFileRecords.addAll(records);
        }
        return logFileRecords.toArray(new LogRecord[logFileRecords.size()]);
    }

    private String formattedRecords(String sessionId) throws IOException {
        StringWriter writer = new StringWriter();
        for (LogRecord record : this.records(sessionId)) {
            writer.append(this.formatter.format(record));
        }
        return writer.toString();
    }

    public synchronized void attachToCurrentThread(String sessionId) {
        ThreadKey threadId = new ThreadKey();
        if (this.threadToSessionMap.get(threadId) == null || this.threadToSessionMap.get(threadId).equals(sessionId)) {
            this.threadToSessionMap.put(threadId, sessionId);
            this.sessionToThreadMap.put(sessionId, threadId);
        }
        this.transferThreadTempLogsToSessionLogs(sessionId);
    }

    public void transferThreadTempLogsToSessionLogs(String sessionId) {
        ThreadKey threadId = new ThreadKey();
        List<LogRecord> threadRecords = this.perThreadTempRecords.get(threadId);
        List<LogRecord> sessionRecords = this.perSessionRecords.get(sessionId);
        if (threadRecords != null) {
            if (sessionRecords == null) {
                sessionRecords = new ArrayList<LogRecord>();
                this.perSessionRecords.put(sessionId, sessionRecords);
            }
            sessionRecords.addAll(threadRecords);
        }
        this.clearThreadTempLogs();
    }

    public synchronized void detachFromCurrentThread() {
        ThreadKey threadId = new ThreadKey();
        String sessionId = this.threadToSessionMap.get(threadId);
        if (sessionId != null) {
            this.threadToSessionMap.remove(threadId);
            this.sessionToThreadMap.remove(sessionId);
            this.clearThreadTempLogs();
        }
    }

    public synchronized void removeSessionLogs(String sessionId) {
        ThreadKey threadId = this.sessionToThreadMap.get(sessionId);
        String sessionIdForThread = this.threadToSessionMap.get(threadId);
        if (threadId != null && sessionIdForThread != null && sessionIdForThread.equals(sessionId)) {
            this.threadToSessionMap.remove(threadId);
            this.sessionToThreadMap.remove(sessionId);
        }
        this.perSessionRecords.remove(sessionId);
        this.logFileRepository.removeLogFile(sessionId);
    }

    public synchronized void clearThreadTempLogs() {
        ThreadKey threadId = new ThreadKey();
        this.perThreadTempRecords.remove(threadId);
    }

    public synchronized String getLog(String sessionId) throws IOException {
        String logs = this.formattedRecords(sessionId);
        logs = "\n<RC_Logs RC_Session_ID=" + sessionId + ">\n" + logs + "\n</RC_Logs>\n";
        return logs;
    }

    private static class ThreadKey {
        private final String name = Thread.currentThread().toString();
        private final Long id = Thread.currentThread().getId();

        ThreadKey() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThreadKey threadKey = (ThreadKey)o;
            return !(this.id == null ? threadKey.id != null : !this.id.equals(threadKey.id));
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }

        public String toString() {
            return "id" + this.id + "," + this.name;
        }
    }
}

