/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.BySelector;
import org.openqa.selenium.remote.server.rest.RestishHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebDriverHandler
implements RestishHandler,
Callable<ResultType> {
    private final Session session;

    protected WebDriverHandler(Session session) {
        this.session = session;
    }

    @Override
    public final ResultType handle() throws Exception {
        FutureTask<ResultType> future = new FutureTask<ResultType>(this);
        try {
            return this.getSession().execute(future);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    public String getSessionId() {
        return this.session.getSessionId().toString();
    }

    public String getScreenshot() {
        Session session = this.getSession();
        return session != null ? session.getAndClearScreenshot() : null;
    }

    protected WebDriver getDriver() {
        Session session = this.getSession();
        return session.getDriver();
    }

    protected Session getSession() {
        return this.session;
    }

    protected KnownElements getKnownElements() {
        return this.getSession().getKnownElements();
    }

    protected Response newResponse() {
        return new Response(this.session.getSessionId());
    }

    protected SessionId getRealSessionId() {
        return this.session == null ? new SessionId("unknown") : this.session.getSessionId();
    }

    protected BySelector newBySelector() {
        return new BySelector();
    }

    public void execute(FutureTask<?> task) throws Exception {
        Session session = this.getSession();
        if (session != null) {
            session.execute(task);
        } else {
            task.run();
        }
    }

    protected WebDriver getUnwrappedDriver() {
        WebDriver toReturn = this.getDriver();
        while (toReturn instanceof WrapsDriver) {
            toReturn = ((WrapsDriver)toReturn).getWrappedDriver();
        }
        return toReturn;
    }
}

