/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.browserlaunchers.Proxies;
import org.openqa.selenium.browserlaunchers.Sleeper;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.CombinedFirefoxLocator;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;

public class FirefoxChromeLauncher
extends AbstractBrowserLauncher {
    private static final Logger log = Logger.getLogger(FirefoxChromeLauncher.class.getName());
    private File customProfileDir = null;
    private boolean closed = false;
    private BrowserInstallation browserInstallation;
    private CommandLine process = null;
    private boolean changeMaxConnections = false;

    public FirefoxChromeLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserString) throws InvalidBrowserExecutableException {
        this(browserOptions, configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("chrome", browserString, (BrowserLocator)new CombinedFirefoxLocator()));
        if (this.browserInstallation == null) {
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
    }

    public FirefoxChromeLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration, browserOptions);
        if (browserInstallation == null) {
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
        this.browserInstallation = browserInstallation;
    }

    protected void launch(String url) {
        try {
            String homePage = new ChromeUrlConvert().convert(url);
            String profilePath = this.makeCustomProfile(homePage);
            this.populateCustomProfileDirectory(profilePath);
            log.info("Launching Firefox...");
            this.process = this.prepareCommand(this.browserInstallation.launcherFilePath(), "-profile", profilePath);
            this.process.setEnvironmentVariable("NO_EM_RESTART", "1");
            this.process.executeAsync();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void populateCustomProfileDirectory(String profilePath) {
        CommandLine command = this.prepareCommand(this.browserInstallation.launcherFilePath(), "-profile", profilePath, "-silent");
        command.setDynamicLibraryPath(this.browserInstallation.libraryPath());
        log.info("Preparing Firefox profile...");
        command.execute();
        try {
            this.waitForFullProfileToBeCreated(20000L);
        }
        catch (RuntimeException e) {
            command.destroy();
            throw e;
        }
    }

    protected CommandLine prepareCommand(String ... commands) {
        CommandLine command = new CommandLine(commands);
        command.setEnvironmentVariable("MOZ_NO_REMOTE", "1");
        Platform platform = Platform.getCurrent();
        if (!platform.is(Platform.MAC) || platform.is(Platform.MAC) && platform.getMajorVersion() <= 10 && platform.getMinorVersion() <= 5) {
            command.setDynamicLibraryPath(this.browserInstallation.libraryPath());
        }
        return command;
    }

    protected void createCustomProfileDir() {
        this.customProfileDir = LauncherUtils.createCustomProfileDir((String)this.sessionId);
    }

    protected void copyDirectory(File sourceDir, File destDir) {
        LauncherUtils.copyDirectory((File)sourceDir, (File)destDir);
    }

    protected File initProfileTemplate() {
        File firefoxProfileTemplate;
        File profilesLocation;
        String relativeProfile = BrowserOptions.getProfile(this.browserConfigurationOptions);
        if (relativeProfile == null) {
            relativeProfile = "";
        }
        if ((profilesLocation = this.getConfiguration().getProfilesLocation()) != null && !"".equals(relativeProfile)) {
            firefoxProfileTemplate = this.getFileFromParent(profilesLocation, relativeProfile);
            if (!firefoxProfileTemplate.exists()) {
                throw new RuntimeException("The profile specified '" + firefoxProfileTemplate.getAbsolutePath() + "' does not exist");
            }
        } else {
            firefoxProfileTemplate = BrowserOptions.getFile(this.browserConfigurationOptions, "firefoxProfileTemplate");
        }
        if (firefoxProfileTemplate != null) {
            this.copyDirectory(firefoxProfileTemplate, this.customProfileDir);
        }
        return firefoxProfileTemplate;
    }

    protected void extractProfileFromJar() throws IOException {
        ResourceExtractor.extractResourcePath(this.getClass(), "/customProfileDirCUSTFFCHROME", this.customProfileDir);
    }

    protected void copySingleFileWithOverwrite(File sourceFile, File destFile) {
        LauncherUtils.copySingleFileWithOverwrite((File)sourceFile, (File)destFile, (boolean)true);
    }

    protected File getFileFromParent(File parent, String child) {
        return new File(parent, child);
    }

    protected void copyCert8db(File firefoxProfileTemplate) {
        File sourceCertFile;
        if (firefoxProfileTemplate != null && (sourceCertFile = this.getFileFromParent(firefoxProfileTemplate, "cert8.db")).exists()) {
            File destCertFile = new File(this.customProfileDir, "cert8.db");
            this.copySingleFileWithOverwrite(sourceCertFile, destCertFile);
        }
    }

    protected void generatePacAndPrefJs(String homePage) throws IOException {
        this.browserConfigurationOptions = Proxies.setProxyRequired((Capabilities)this.browserConfigurationOptions, (boolean)false);
        if (this.browserConfigurationOptions.is("captureNetworkTraffic") || this.browserConfigurationOptions.is("addCustomRequestHeaders") || this.browserConfigurationOptions.is("trustAllSSLCertificates")) {
            this.browserConfigurationOptions = Proxies.setProxyEverything((Capabilities)this.browserConfigurationOptions, (boolean)true);
            this.browserConfigurationOptions = Proxies.setProxyRequired((Capabilities)this.browserConfigurationOptions, (boolean)true);
        }
        LauncherUtils.generatePacAndPrefJs((File)this.customProfileDir, (int)this.getPort(), (String)homePage, (boolean)this.changeMaxConnections, (long)this.getTimeout(), (Capabilities)this.browserConfigurationOptions);
    }

    private String makeCustomProfile(String homePage) throws IOException {
        this.createCustomProfileDir();
        File firefoxProfileTemplate = this.initProfileTemplate();
        this.extractProfileFromJar();
        this.copyCert8db(firefoxProfileTemplate);
        this.copyRunnerHtmlFiles();
        this.changeMaxConnections = this.browserConfigurationOptions.is("changeMaxConnections");
        this.generatePacAndPrefJs(homePage);
        return this.customProfileDir.getAbsolutePath();
    }

    private void copyRunnerHtmlFiles() {
        String guid = "{503A0CD4-EDC8-489b-853B-19E0BAA8F0A4}";
        File extensionDir = new File(this.customProfileDir, "extensions/" + guid);
        File htmlDir = new File(extensionDir, "chrome");
        htmlDir.mkdirs();
        LauncherUtils.extractHTAFile((File)htmlDir, (int)this.getPort(), (String)"/core/TestRunner.html", (String)"TestRunner.html");
        LauncherUtils.extractHTAFile((File)htmlDir, (int)this.getPort(), (String)"/core/TestPrompt.html", (String)"TestPrompt.html");
        LauncherUtils.extractHTAFile((File)htmlDir, (int)this.getPort(), (String)"/core/RemoteRunner.html", (String)"RemoteRunner.html");
    }

    public void close() {
        if (this.closed) {
            return;
        }
        FileLockRemainedException fileLockException = null;
        if (this.process != null) {
            try {
                this.killFirefoxProcess();
            }
            catch (FileLockRemainedException flre) {
                fileLockException = flre;
            }
        }
        if (this.customProfileDir != null) {
            try {
                this.removeCustomProfileDir();
            }
            catch (RuntimeException e) {
                if (fileLockException != null) {
                    log.log(Level.SEVERE, "Couldn't delete custom Firefox profile directory", e);
                    log.severe("Perhaps caused by this exception:");
                    log.log(Level.SEVERE, "Perhaps caused by this exception:", fileLockException);
                    throw new RuntimeException("Couldn't delete custom Firefox profile directory, presumably because task kill failed; see error LOGGER!", e);
                }
                throw e;
            }
        }
        this.closed = true;
    }

    protected void removeCustomProfileDir() throws RuntimeException {
        LauncherUtils.deleteTryTryAgain((File)this.customProfileDir, (int)6);
    }

    protected void killFirefoxProcess() throws FileLockRemainedException {
        log.info("Killing Firefox...");
        int exitValue = this.process.destroy();
        if (exitValue == 0) {
            log.warning("Firefox seems to have ended on its own (did we kill the real browser???)");
        }
        this.waitForFileLockToGoAway(0L, 500L);
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir, "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            Sleeper.sleepTight((long)500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            Sleeper.sleepTight((long)500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    private void waitForFullProfileToBeCreated(long timeout) {
        File testFile = new File(this.customProfileDir, "extensions.ini");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            Sleeper.sleepTight((long)500L);
            if (!testFile.exists()) continue;
        }
        if (!testFile.exists()) {
            throw new RuntimeException("Timed out waiting for profile to be created!");
        }
        long subTimeout = timeout - (System.currentTimeMillis() - start);
        try {
            this.waitForFileLockToGoAway(subTimeout, 500L);
        }
        catch (FileLockRemainedException e) {
            throw new RuntimeException("Firefox refused shutdown while preparing a profile", e);
        }
    }

    protected void setCustomProfileDir(File value) {
        this.customProfileDir = value;
    }

    protected void setCommandLine(CommandLine p) {
        this.process = p;
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL) {
        if (suiteUrl != null && suiteUrl.startsWith("TestPrompt.html?")) {
            suiteUrl = suiteUrl.replaceFirst("^TestPrompt\\.html\\?", "chrome://src/content/TestPrompt.html?");
        }
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl((String)browserURL, (String)suiteUrl, (!BrowserOptions.isSingleWindow(this.browserConfigurationOptions) ? 1 : 0) != 0, (int)this.getPort()));
    }

    public void launchRemoteSession(String browserURL) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl((String)browserURL, (String)this.sessionId, (!BrowserOptions.isSingleWindow(this.browserConfigurationOptions) ? 1 : 0) != 0, (int)this.getPort(), (boolean)this.browserConfigurationOptions.is("browserSideLog")));
    }

    public static class ChromeUrlConvert {
        public String convert(String httpUrl) throws MalformedURLException {
            String query = LauncherUtils.getQueryString((String)httpUrl);
            String file = new File(new URL(httpUrl).getPath()).getName();
            return "chrome://src/content/" + file + "?" + query;
        }
    }

    protected class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

