/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.ComponentEvent;
import org.openqa.jetty.util.ComponentListener;
import org.openqa.jetty.util.EventProvider;
import org.openqa.jetty.util.LazyList;
import org.openqa.jetty.util.LifeCycle;
import org.openqa.jetty.util.LifeCycleEvent;
import org.openqa.jetty.util.LifeCycleListener;

public abstract class Container
implements LifeCycle,
EventProvider,
Serializable {
    private static Log log = LogFactory.getLog(Container.class);
    private Object _eventListeners;
    private Object _components;
    private transient boolean _started;
    private transient boolean _starting;
    private transient boolean _stopping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void start() throws Exception {
        EventListener listener;
        int i;
        if (this._started || this._starting) {
            return;
        }
        this._starting = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting " + this));
        }
        LifeCycleEvent event = new LifeCycleEvent(this);
        for (i = 0; i < LazyList.size(this._eventListeners); ++i) {
            listener = (EventListener)LazyList.get(this._eventListeners, i);
            if (!(listener instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)listener).lifeCycleStarting(event);
        }
        try {
            this.doStart();
            this._started = true;
            log.info((Object)("Started " + this));
            for (i = 0; i < LazyList.size(this._eventListeners); ++i) {
                listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (!(listener instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)listener).lifeCycleStarted(event);
            }
        }
        catch (Throwable e) {
            LifeCycleEvent failed = new LifeCycleEvent(this, e);
            for (int i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
                EventListener listener2 = (EventListener)LazyList.get(this._eventListeners, i2);
                if (!(listener2 instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)listener2).lifeCycleFailure(event);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            log.warn((Object)"EXCEPTION ", e);
        }
        finally {
            this._starting = false;
        }
    }

    protected abstract void doStart() throws Exception;

    public synchronized boolean isStarted() {
        return this._started;
    }

    protected synchronized boolean isStarting() {
        return this._starting;
    }

    protected synchronized boolean isStopping() {
        return this._stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() throws InterruptedException {
        EventListener listener;
        int i;
        if (!this._started || this._stopping) {
            return;
        }
        this._stopping = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping " + this));
        }
        LifeCycleEvent event = new LifeCycleEvent(this);
        for (i = 0; i < LazyList.size(this._eventListeners); ++i) {
            listener = (EventListener)LazyList.get(this._eventListeners, i);
            if (!(listener instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)listener).lifeCycleStopping(event);
        }
        try {
            this.doStop();
            this._started = false;
            log.info((Object)("Stopped " + this));
            for (i = 0; i < LazyList.size(this._eventListeners); ++i) {
                listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (!(listener instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)listener).lifeCycleStopped(event);
            }
        }
        catch (Throwable e) {
            event = new LifeCycleEvent(this, e);
            for (int i2 = 0; i2 < LazyList.size(this._eventListeners); ++i2) {
                EventListener listener2 = (EventListener)LazyList.get(this._eventListeners, i2);
                if (!(listener2 instanceof LifeCycleListener)) continue;
                ((LifeCycleListener)listener2).lifeCycleFailure(event);
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            log.warn((Object)"EXCEPTION ", e);
        }
        finally {
            this._stopping = false;
        }
    }

    protected abstract void doStop() throws Exception;

    protected void addComponent(Object o) {
        if (!LazyList.contains(this._components, o)) {
            this._components = LazyList.add(this._components, o);
            if (log.isDebugEnabled()) {
                log.debug((Object)("add component: " + o));
            }
            ComponentEvent event = new ComponentEvent(this, o);
            for (int i = 0; i < LazyList.size(this._eventListeners); ++i) {
                EventListener listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (!(listener instanceof ComponentListener)) continue;
                ((ComponentListener)listener).addComponent(event);
            }
        }
    }

    protected void removeComponent(Object o) {
        if (LazyList.contains(this._components, o)) {
            this._components = LazyList.remove(this._components, o);
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove component: " + o));
            }
            ComponentEvent event = new ComponentEvent(this, o);
            for (int i = 0; i < LazyList.size(this._eventListeners); ++i) {
                EventListener listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (!(listener instanceof ComponentListener)) continue;
                ((ComponentListener)listener).removeComponent(event);
            }
        }
    }

    public void addEventListener(EventListener listener) throws IllegalArgumentException {
        if (this._eventListeners == null) {
            this._eventListeners = new ArrayList();
        }
        if (listener instanceof ComponentListener || listener instanceof LifeCycleListener) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addEventListener: " + listener));
            }
            this._eventListeners = LazyList.add(this._eventListeners, listener);
        }
    }

    public void removeEventListener(EventListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeEventListener: " + listener));
        }
        this._eventListeners = LazyList.remove(this._eventListeners, listener);
    }

    public void destroy() {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        if (this._components != null && this._eventListeners != null) {
            for (int c = 0; c < LazyList.size(this._components); ++c) {
                Object o = LazyList.get(this._components, c);
                if (o instanceof HttpContext) {
                    ((HttpContext)o).destroy();
                }
                ComponentEvent event = new ComponentEvent(this, o);
                for (int i = 0; i < LazyList.size(this._eventListeners); ++i) {
                    EventListener listener = (EventListener)LazyList.get(this._eventListeners, i);
                    if (!(listener instanceof ComponentListener)) continue;
                    ((ComponentListener)listener).removeComponent(event);
                }
            }
        }
        this._components = null;
        this._eventListeners = null;
    }

    public Collection getComponents() {
        return LazyList.getList(this._eventListeners, false);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (int c = 0; c < LazyList.size(this._components); ++c) {
            Object o = LazyList.get(this._components, c);
            ComponentEvent event = new ComponentEvent(this, o);
            for (int i = 0; i < LazyList.size(this._eventListeners); ++i) {
                EventListener listener = (EventListener)LazyList.get(this._eventListeners, i);
                if (!(listener instanceof ComponentListener)) continue;
                ((ComponentListener)listener).addComponent(event);
            }
        }
    }
}

