/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.selenium.remote.DesiredCapabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class NewSessionRequestQueue {
    private static final Logger log = Logger.getLogger(NewSessionRequestQueue.class.getName());
    private final List<RequestHandler> newSessionRequests = new ArrayList<RequestHandler>();

    NewSessionRequestQueue() {
    }

    public synchronized void add(RequestHandler request) {
        this.newSessionRequests.add(request);
    }

    public synchronized void processQueue(Predicate<RequestHandler> handlerConsumer, Prioritizer prioritizer) {
        List<RequestHandler> copy;
        if (prioritizer != null) {
            copy = new ArrayList<RequestHandler>(this.newSessionRequests);
            Collections.sort(copy);
        } else {
            copy = this.newSessionRequests;
        }
        ArrayList<RequestHandler> matched = new ArrayList<RequestHandler>();
        for (RequestHandler request : copy) {
            if (!handlerConsumer.apply((Object)request)) continue;
            matched.add(request);
        }
        for (RequestHandler req : matched) {
            boolean ok = this.removeNewSessionRequest(req);
            if (ok) continue;
            log.severe("Bug removing request " + req);
        }
    }

    public synchronized void clearNewSessionRequests() {
        this.newSessionRequests.clear();
    }

    public synchronized boolean removeNewSessionRequest(RequestHandler request) {
        return this.newSessionRequests.remove(request);
    }

    public synchronized Iterable<DesiredCapabilities> getDesiredCapabilities() {
        ArrayList<DesiredCapabilities> result = new ArrayList<DesiredCapabilities>();
        for (RequestHandler req : this.newSessionRequests) {
            result.add(new DesiredCapabilities(req.getDesiredCapabilities()));
        }
        return result;
    }

    public synchronized int getNewSessionRequestCount() {
        return this.newSessionRequests.size();
    }

    public synchronized void stop() {
        for (RequestHandler newSessionRequest : this.newSessionRequests) {
            newSessionRequest.stop();
        }
    }
}

