/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.AsyncExecute;
import org.openqa.selenium.browserlaunchers.LauncherUtils;
import org.openqa.selenium.browserlaunchers.WindowsProxyManager;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.InternetExplorerLocator;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.WindowsUtils;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserOptions;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;

public class InternetExplorerCustomProxyLauncher
extends AbstractBrowserLauncher {
    private static final Logger log = Logger.getLogger(InternetExplorerCustomProxyLauncher.class.getName());
    private File customProxyPACDir;
    private String[] cmdarray;
    private BrowserInstallation browserInstallation;
    private Process process;
    protected boolean customPACappropriate = true;
    protected WindowsProxyManager wpm;
    private static boolean alwaysChangeMaxConnections = false;
    protected boolean changeMaxConnections = alwaysChangeMaxConnections;

    public InternetExplorerCustomProxyLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        this(browserOptions, configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("iexplore", browserLaunchLocation, (BrowserLocator)new InternetExplorerLocator()));
    }

    public InternetExplorerCustomProxyLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration, browserOptions);
        this.browserInstallation = browserInstallation;
        this.wpm = new WindowsProxyManager(true, sessionId, this.getPort(), this.getPort());
    }

    protected void changeRegistrySettings() {
        this.wpm.changeRegistrySettings(this.browserConfigurationOptions);
    }

    public void launch(String url) {
        try {
            this.setupSystem(url);
            log.info("Launching Internet Explorer...");
            CommandLine exe = new CommandLine(this.cmdarray);
            this.process = exe.executeAsync();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void setupSystem(String url) throws IOException {
        if (WindowsUtils.thisIsWindows()) {
            if (!this.browserConfigurationOptions.is("honorSystemProxy")) {
                this.setupSystemProxy();
            }
            this.customProxyPACDir = this.wpm.getCustomProxyPACDir();
            File killableProcessWrapper = new File(this.customProxyPACDir, "killableprocess.exe");
            ResourceExtractor.extractResourcePath(InternetExplorerCustomProxyLauncher.class, "/killableprocess/killableprocess.exe", killableProcessWrapper);
            this.cmdarray = new String[]{killableProcessWrapper.getAbsolutePath(), this.browserInstallation.launcherFilePath(), "-new", url};
        } else {
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), url};
        }
    }

    public void close() {
        if (WindowsUtils.thisIsWindows() && !this.browserConfigurationOptions.is("honorSystemProxy")) {
            this.restoreSystemProxy();
        }
        if (this.process == null) {
            return;
        }
        if (this.browserConfigurationOptions.is("killProcessesByName")) {
            WindowsUtils.tryToKillByName((String)"iexplore.exe");
        }
        try {
            this.process.getOutputStream().write(10);
            this.process.getOutputStream().flush();
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AsyncExecute.killProcess((Process)this.process);
        if (this.customPACappropriate) {
            LauncherUtils.recursivelyDeleteDir((File)this.customProxyPACDir);
        }
    }

    private void restoreSystemProxy() {
        this.wpm.restoreRegistrySettings(this.browserConfigurationOptions.is("ensureCleanSession"));
    }

    public Process getProcess() {
        return this.process;
    }

    public static void main(String[] args) {
        InternetExplorerCustomProxyLauncher l = new InternetExplorerCustomProxyLauncher(BrowserOptions.newBrowserOptions(), new RemoteControlConfiguration(), "CUSTIE", (String)null);
        l.launch("http://www.google.com/");
        int seconds = 5;
        System.out.println("Killing browser in " + Integer.toString(seconds) + " seconds");
        AsyncExecute.sleepTight((long)(seconds * 1000));
        l.close();
        System.out.println("He's dead now, right?");
    }

    public static void setChangeMaxConnections(boolean changeMaxConnections) {
        alwaysChangeMaxConnections = changeMaxConnections;
    }

    private void setupSystemProxy() {
        this.wpm.backupRegistrySettings();
        this.changeRegistrySettings();
    }
}

