/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.grid.web.servlet.handler.WebDriverRequestHandler;

public class DriverServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = -1693540182205547227L;

    public DriverServlet() {
        this(null);
    }

    public DriverServlet(Registry registry) {
        super(registry);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestHandler req = null;
        try {
            req = RequestHandler.createHandler(request, response, this.getRegistry());
            req.process();
        }
        catch (Throwable e) {
            if (req instanceof WebDriverRequestHandler) {
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                response.setStatus(500);
                JSONObject resp = new JSONObject();
                try {
                    ExternalSessionKey serverSession = req.getServerSession();
                    resp.put("sessionId", (Object)(serverSession != null ? serverSession.getKey() : null));
                    resp.put("status", 13);
                    JSONObject value = new JSONObject();
                    value.put("message", (Object)e.getMessage());
                    value.put("class", (Object)e.getClass().getCanonicalName());
                    JSONArray stacktrace = new JSONArray();
                    for (StackTraceElement ste : e.getStackTrace()) {
                        JSONObject st = new JSONObject();
                        st.put("fileName", (Object)ste.getFileName());
                        st.put("className", (Object)ste.getClassName());
                        st.put("methodName", (Object)ste.getMethodName());
                        st.put("lineNumber", ste.getLineNumber());
                        stacktrace.put((Object)st);
                    }
                    value.put("stackTrace", (Object)stacktrace);
                    resp.put("value", (Object)value);
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
                String json = resp.toString();
                ByteArrayInputStream in = new ByteArrayInputStream(json.getBytes("UTF-8"));
                try {
                    ByteStreams.copy((InputStream)in, (OutputStream)response.getOutputStream());
                    Object var15_15 = null;
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    ((InputStream)in).close();
                    response.getOutputStream().close();
                    throw throwable;
                }
                ((InputStream)in).close();
                response.getOutputStream().close();
                {
                }
            }
            throw new IOException(e);
        }
    }
}

