/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.browserlaunchers.locators.BrowserInstallation;
import org.openqa.selenium.browserlaunchers.locators.BrowserLocator;
import org.openqa.selenium.browserlaunchers.locators.CombinedFirefoxLocator;
import org.openqa.selenium.browserlaunchers.locators.Firefox2Locator;
import org.openqa.selenium.browserlaunchers.locators.Firefox3Locator;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.InvalidBrowserExecutableException;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionFirefoxCustomProfileLauncher;

public class FirefoxLauncher
implements BrowserLauncher {
    final BrowserLauncher realLauncher;

    public FirefoxLauncher(Capabilities browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) throws InvalidBrowserExecutableException {
        BrowserInstallation installation;
        String mode;
        String browserName = "firefox";
        CombinedFirefoxLocator locator = new CombinedFirefoxLocator();
        String version = (String)browserOptions.getCapability("version");
        if ("2".equals(version)) {
            browserName = "firefox2";
            locator = new Firefox2Locator();
        }
        if ("3".equals(version)) {
            browserName = "firefox3";
            locator = new Firefox3Locator();
        }
        if ((mode = (String)browserOptions.getCapability("mode")) == null) {
            mode = "chrome";
        }
        if ("default".equals(mode)) {
            mode = "chrome";
        }
        if ((installation = ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation(browserName, browserLaunchLocation, (BrowserLocator)locator)) == null) {
            throw new InvalidBrowserExecutableException("The specified path to the browser executable is invalid.");
        }
        if ("chrome".equals(mode)) {
            this.realLauncher = new FirefoxChromeLauncher(browserOptions, configuration, sessionId, installation);
            return;
        }
        boolean proxyInjectionMode = browserOptions.is("proxyInjectionMode") || "proxyInjection".equals(mode);
        boolean globalProxyInjectionMode = configuration.getProxyInjectionModeArg();
        if (proxyInjectionMode && !globalProxyInjectionMode && proxyInjectionMode) {
            throw new RuntimeException("You requested proxy injection mode, but this server wasn't configured with -proxyInjectionMode on the command line");
        }
        proxyInjectionMode = globalProxyInjectionMode;
        if (proxyInjectionMode) {
            this.realLauncher = new ProxyInjectionFirefoxCustomProfileLauncher(browserOptions, configuration, sessionId, installation);
            return;
        }
        if (!"proxy".equals(mode)) {
            throw new RuntimeException("Unrecognized browser mode: " + mode);
        }
        this.realLauncher = new FirefoxCustomProfileLauncher(browserOptions, configuration, sessionId, installation);
    }

    public void close() {
        this.realLauncher.close();
    }

    public Process getProcess() {
        return this.realLauncher.getProcess();
    }

    public void launchHTMLSuite(String suiteUrl, String baseUrl) {
        this.realLauncher.launchHTMLSuite(suiteUrl, baseUrl);
    }

    public void launchRemoteSession(String url) {
        this.realLauncher.launchRemoteSession(url);
    }
}

