/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.renderer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.renderer.ErrorJsonResult;
import org.openqa.selenium.remote.server.rest.Handler;

public class JsonErrorExceptionResult
extends ErrorJsonResult {
    private final ErrorCodes errorCodes;
    private final String exceptionName;

    public JsonErrorExceptionResult(String exceptionName, String responseOn) {
        super(responseOn);
        this.exceptionName = exceptionName.substring(1);
        this.errorCodes = new ErrorCodes();
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Handler handler) throws Exception {
        Response res = this.prepareResponseObject(request);
        request.setAttribute(this.propertyName, (Object)res);
        super.render(request, response, handler);
    }

    public Response prepareResponseObject(HttpServletRequest request) throws JSONException {
        Throwable thrown = (Throwable)request.getAttribute(this.exceptionName);
        Response res = new Response();
        res.setStatus(this.errorCodes.toStatusCode(thrown));
        String sessionId = HttpCommandExecutor.getSessionId((String)request.getRequestURI());
        res.setSessionId(sessionId != null ? sessionId : "");
        if (thrown != null) {
            String raw = new BeanToJsonConverter().convert((Object)thrown);
            JSONObject error = new JSONObject(raw);
            error.put("screen", request.getAttribute("screen"));
            res.setValue((Object)error);
        }
        return res;
    }
}

