/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.proxy;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHttpRequest;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.exception.RemoteException;
import org.openqa.grid.internal.exception.RemoteNotReachableException;
import org.openqa.grid.internal.listeners.CommandListener;
import org.openqa.grid.internal.listeners.SelfHealingProxy;
import org.openqa.grid.internal.listeners.TimeoutListener;
import org.openqa.grid.internal.utils.HtmlRenderer;
import org.openqa.grid.selenium.utils.WebProxyHtmlRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebRemoteProxy
extends RemoteProxy
implements TimeoutListener,
SelfHealingProxy,
CommandListener {
    private final HtmlRenderer renderer = new WebProxyHtmlRenderer(this);
    private boolean down = false;
    private boolean poll = true;
    int nbFailedPoll = 0;
    private List<RemoteException> errors = new CopyOnWriteArrayList<RemoteException>();
    private Thread pollingThread = null;

    public WebRemoteProxy(RegistrationRequest request) {
        super(request);
    }

    @Override
    public abstract void beforeRelease(TestSession var1);

    @Override
    public void afterCommand(TestSession session, HttpServletRequest request, HttpServletResponse response) {
        session.put("lastCommand", request.getMethod() + " - " + request.getPathInfo() + " executing ...");
    }

    @Override
    public void beforeCommand(TestSession session, HttpServletRequest request, HttpServletResponse response) {
        session.put("lastCommand", request.getMethod() + " - " + request.getPathInfo() + " executed.");
    }

    @Override
    public HtmlRenderer getHtmlRender() {
        return this.renderer;
    }

    public boolean isAlive() {
        HttpResponse response;
        String url = this.getRemoteURL().toExternalForm() + "/status";
        BasicHttpRequest r = new BasicHttpRequest("GET", url);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpHost host = new HttpHost(this.getRemoteURL().getHost(), this.getRemoteURL().getPort());
        try {
            response = client.execute(host, (HttpRequest)r);
        }
        catch (ClientProtocolException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        int code = response.getStatusLine().getStatusCode();
        return code == 404 || code == 500;
    }

    @Override
    public void startPolling() {
        this.pollingThread = new Thread(new Runnable(){

            public void run() {
                while (WebRemoteProxy.this.poll) {
                    try {
                        Thread.sleep(10000L);
                        if (!WebRemoteProxy.this.isAlive()) {
                            if (WebRemoteProxy.this.down) continue;
                            ++WebRemoteProxy.this.nbFailedPoll;
                            if (WebRemoteProxy.this.nbFailedPoll < 2) continue;
                            WebRemoteProxy.this.addNewEvent(new RemoteNotReachableException("Cannot reach the remote."));
                            continue;
                        }
                        WebRemoteProxy.this.down = false;
                        WebRemoteProxy.this.nbFailedPoll = 0;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        this.pollingThread.start();
    }

    @Override
    public void stopPolling() {
        this.poll = false;
        this.pollingThread.interrupt();
    }

    @Override
    public void addNewEvent(RemoteException event) {
        this.errors.add(event);
        this.onEvent(this.errors, event);
    }

    @Override
    public void onEvent(List<RemoteException> events, RemoteException lastInserted) {
        for (RemoteException e : events) {
            if (!(e instanceof RemoteNotReachableException)) continue;
            this.down = true;
            this.errors.clear();
        }
    }

    @Override
    public TestSession getNewSession(Map<String, Object> requestedCapability) {
        if (this.down) {
            return null;
        }
        return super.getNewSession(requestedCapability);
    }

    public boolean isDown() {
        return this.down;
    }
}

