/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.renderer;

import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.server.rest.Handler;
import org.openqa.selenium.remote.server.rest.Renderer;

public class JsonResult
implements Renderer {
    protected String propertyName;

    public JsonResult(String propertyName) {
        this.propertyName = propertyName.startsWith(":") ? propertyName.substring(1) : propertyName;
    }

    public void render(HttpServletRequest request, HttpServletResponse response, Handler handler) throws Exception {
        Object result = request.getAttribute(this.propertyName);
        String json = new BeanToJsonConverter().convert(result);
        byte[] data = Charset.forName("utf-8").encode(json).array();
        int length = json == null ? 0 : data.length;
        response.setContentLength(length);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getOutputStream().write(data);
        response.getOutputStream().flush();
    }
}

