/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.handler.BySelector;
import org.openqa.selenium.remote.server.handler.WebElementHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindChildElement
extends WebElementHandler
implements JsonParametersAware {
    private By by;
    private Response response;

    public FindChildElement(DriverSessions sessions) {
        super(sessions);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        String method = (String)allParameters.get("using");
        String selector = (String)allParameters.get("value");
        this.by = new BySelector().pickFrom(method, selector);
    }

    @Override
    public ResultType call() throws Exception {
        this.response = this.newResponse();
        WebElement element = this.getElement().findElement(this.by);
        String elementId = this.getKnownElements().add(element);
        this.response.setValue((Object)ImmutableMap.of((Object)"ELEMENT", (Object)elementId));
        return ResultType.SUCCESS;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return String.format("[find child element: %s, %s", this.getElementAsString(), this.by);
    }
}

