/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Path;
import org.openqa.jetty.log.LogFactory;
import org.openqa.selenium.server.browserlaunchers.SystemUtils;
import org.openqa.selenium.server.browserlaunchers.UnixUtils;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;
import org.openqa.selenium.server.log.AntJettyLoggerBuildListener;

public class AsyncExecute
extends Execute {
    static Log log = LogFactory.getLog(AsyncExecute.class);
    File workingDirectory;
    Project project = new Project();
    boolean useVMLauncher = true;
    private final Map<String, String> environmentBuilder;

    public AsyncExecute() {
        this.project.addBuildListener((BuildListener)new AntJettyLoggerBuildListener(log));
        this.environmentBuilder = new HashMap<String, String>(2);
    }

    public static void sleepTightInSeconds(long timeoutInSeconds) {
        AsyncExecute.sleepTight(timeoutInSeconds * 1000L);
    }

    public static void sleepTight(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Process asyncSpawn() throws IOException {
        if (!this.environmentBuilder.isEmpty()) {
            this.setActualExecuteEnvironment();
        }
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = AsyncExecute.launch((Project)this.project, (String[])this.getCommandline(), (String[])this.getEnvironment(), (File)this.workingDirectory, (boolean)this.useVMLauncher);
        if (Os.isFamily((String)"windows")) {
            AsyncExecute.sleepTight(1000L);
        }
        OutputStream dummyOut = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        PumpStreamHandler streamHandler = new PumpStreamHandler(dummyOut);
        streamHandler.setProcessErrorStream(process.getErrorStream());
        streamHandler.setProcessOutputStream(process.getInputStream());
        streamHandler.start();
        this.project.log("spawned process " + process.toString(), 3);
        return process;
    }

    public int execute() throws IOException {
        if (!this.environmentBuilder.isEmpty()) {
            this.setActualExecuteEnvironment();
        }
        return super.execute();
    }

    public static boolean isAlive(Process p) {
        try {
            p.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        return false;
    }

    public static int waitForProcessDeath(Process p, long timeout) {
        ProcessWaiter pw = new ProcessWaiter(p);
        Thread waiter = new Thread(pw);
        waiter.start();
        try {
            waiter.join(timeout);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bug? Main interrupted while waiting for process", e);
        }
        if (waiter.isAlive()) {
            waiter.interrupt();
        }
        try {
            waiter.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Bug? Main interrupted while waiting for dead process waiter", e);
        }
        InterruptedException ie = pw.getException();
        if (ie != null) {
            throw new ProcessStillAliveException("Timeout waiting for process to die", ie);
        }
        return p.exitValue();
    }

    public static int killProcess(Process process) {
        int exitValue;
        process.destroy();
        try {
            exitValue = AsyncExecute.waitForProcessDeath(process, 10000L);
        }
        catch (ProcessStillAliveException ex) {
            if (WindowsUtils.thisIsWindows()) {
                throw ex;
            }
            try {
                log.info((Object)"Process didn't die after 10 seconds");
                UnixUtils.kill9(process);
                exitValue = AsyncExecute.waitForProcessDeath(process, 10000L);
            }
            catch (Exception e) {
                log.error((Object)"Process refused to die after 10 seconds, and couldn't kill9 it", (Throwable)e);
                throw new RuntimeException("Process refused to die after 10 seconds, and couldn't kill9 it: " + e.getMessage(), ex);
            }
        }
        return exitValue;
    }

    public static File whichExec(String exec) {
        Path p = null;
        String pathStr = WindowsUtils.getPath();
        if (pathStr != null) {
            p = new Path(new Project(), pathStr);
        }
        if (p != null) {
            String[] dirs;
            for (String dir : dirs = p.list()) {
                File executableFile = new File(dir, exec);
                if (!executableFile.exists()) continue;
                return executableFile;
            }
        }
        return null;
    }

    public void setLibraryPath(String newLibraryPath) {
        if (WindowsUtils.thisIsWindows()) {
            return;
        }
        this.environmentBuilder.put(SystemUtils.libraryPathEnvironmentVariable(), newLibraryPath);
    }

    public void setEnvironmentVariable(String name, String value) {
        this.environmentBuilder.put(name, value);
    }

    protected void setActualExecuteEnvironment() {
        if (this.environmentBuilder.isEmpty()) {
            return;
        }
        ArrayList<String> env = new ArrayList<String>(this.environmentBuilder.size());
        for (Map.Entry<String, String> variable : this.environmentBuilder.entrySet()) {
            env.add(variable.getKey() + "=" + variable.getValue());
        }
        this.setEnvironment(env.toArray(new String[env.size()]));
    }

    private static class ProcessWaiter
    implements Runnable {
        private InterruptedException t;
        private Process p;

        public InterruptedException getException() {
            return this.t;
        }

        public ProcessWaiter(Process p) {
            this.p = p;
        }

        public void run() {
            try {
                this.p.waitFor();
            }
            catch (InterruptedException e) {
                this.t = e;
            }
        }
    }

    public static class ProcessStillAliveException
    extends RuntimeException {
        public ProcessStillAliveException() {
        }

        public ProcessStillAliveException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProcessStillAliveException(String message) {
            super(message);
        }

        public ProcessStillAliveException(Throwable cause) {
            super(cause);
        }
    }
}

