/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.rest;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.PropertyMunger;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.LogTo;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.Handler;
import org.openqa.selenium.remote.server.rest.Renderer;
import org.openqa.selenium.remote.server.rest.Result;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultConfig {
    private final String[] sections;
    private final Class<? extends Handler> handlerClazz;
    private final DriverSessions sessions;
    private final Map<ResultType, Set<Result>> resultToRender = new HashMap<ResultType, Set<Result>>();
    private final LogTo logger;

    public ResultConfig(String url, Class<? extends Handler> handlerClazz, DriverSessions sessions, LogTo logger) {
        this.logger = logger;
        if (url == null || handlerClazz == null) {
            throw new IllegalArgumentException("You must specify the handler and the url");
        }
        this.sections = url.split("/");
        this.handlerClazz = handlerClazz;
        this.sessions = sessions;
    }

    public Handler getHandler(String url) throws Exception {
        if (!this.isFor(url)) {
            return null;
        }
        return this.populate(this.createInstance(this.handlerClazz), url);
    }

    private Handler createInstance(Class<? extends Handler> handlerClazz) throws Exception {
        try {
            Constructor<? extends Handler> constructor = handlerClazz.getConstructor(DriverSessions.class);
            return constructor.newInstance(this.sessions);
        }
        catch (NoSuchMethodException e) {
            return handlerClazz.newInstance();
        }
    }

    public boolean isFor(String urlToMatch) {
        String[] allParts = urlToMatch.split("/");
        if (this.sections.length != allParts.length) {
            return false;
        }
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i].startsWith(":") || this.sections[i].equals(allParts[i])) continue;
            return false;
        }
        return true;
    }

    protected Handler populate(Handler handler, String pathString) {
        String[] strings = pathString.split("/");
        for (int i = 0; i < this.sections.length; ++i) {
            if (!this.sections[i].startsWith(":")) continue;
            try {
                PropertyMunger.set((String)this.sections[i].substring(1), (Object)handler, (Object)strings[i]);
                continue;
            }
            catch (Exception e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        return handler;
    }

    public ResultConfig on(ResultType success, Renderer renderer) {
        return this.on(success, renderer, "");
    }

    public ResultConfig on(ResultType success, Renderer renderer, String mimeType) {
        Set<Result> results = this.resultToRender.get((Object)success);
        if (results == null) {
            results = new LinkedHashSet<Result>();
            this.resultToRender.put(success, results);
        }
        results.add(new Result(mimeType, renderer));
        return this;
    }

    public void handle(String pathInfo, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
        ResultType result;
        Handler handler;
        block7: {
            handler = this.getHandler(pathInfo);
            if (handler instanceof JsonParametersAware) {
                this.setJsonParameters(request, handler);
            }
            request.setAttribute("handler", (Object)handler);
            try {
                this.logger.log(String.format("Executing: %s at URL: %s)", handler.toString(), pathInfo));
                result = handler.handle();
                this.addHandlerAttributesToRequest(request, handler);
                this.logger.log("Done: " + pathInfo);
            }
            catch (Exception e) {
                result = ResultType.EXCEPTION;
                Throwable toUse = e;
                if (e instanceof UndeclaredThrowableException) {
                    toUse = e.getCause().getCause();
                }
                this.logger.log("Exception: " + toUse.getMessage());
                request.setAttribute("exception", (Object)toUse);
                if (!(handler instanceof WebDriverHandler)) break block7;
                request.setAttribute("screen", (Object)((WebDriverHandler)handler).getScreenshot());
            }
        }
        Set<Result> results = this.resultToRender.get((Object)result);
        Result tempToUse = null;
        for (Result res : results) {
            if (tempToUse != null && !res.isExactMimeTypeMatch(request.getHeader("Accept"))) continue;
            tempToUse = res;
        }
        final Result toUse = tempToUse;
        if (handler instanceof WebDriverHandler) {
            FutureTask<ResultType> task = new FutureTask<ResultType>(new Callable<ResultType>(){

                @Override
                public ResultType call() throws Exception {
                    toUse.getRenderer().render(request, response, handler);
                    return null;
                }
            });
            ((WebDriverHandler)handler).execute(task);
            task.get();
        } else {
            toUse.getRenderer().render(request, response, handler);
        }
    }

    private void setJsonParameters(HttpServletRequest request, Handler handler) throws Exception {
        BufferedReader reader = new BufferedReader(request.getReader());
        StringBuilder builder = new StringBuilder();
        String line = reader.readLine();
        while (line != null) {
            builder.append(line);
            line = reader.readLine();
        }
        String raw = builder.toString();
        if (raw.startsWith("[")) {
            List parameters = (List)new JsonToBeanConverter().convert(List.class, (Object)builder.toString());
            ((JsonParametersAware)((Object)handler)).setJsonParameters(parameters);
        }
    }

    protected void addHandlerAttributesToRequest(HttpServletRequest request, Handler handler) throws Exception {
        PropertyDescriptor[] properties;
        BeanInfo info = Introspector.getBeanInfo(handler.getClass());
        for (PropertyDescriptor property : properties = info.getPropertyDescriptors()) {
            Method readMethod = property.getReadMethod();
            if (readMethod == null) continue;
            Object result = readMethod.invoke((Object)handler, new Object[0]);
            request.setAttribute(property.getName(), result);
        }
    }
}

