/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverSessions {
    private DriverFactory factory = new DriverFactory();
    private static Map<SessionId, Session> sessionIdToDriver = new ConcurrentHashMap<SessionId, Session>();
    private static Map<Capabilities, String> defaultDrivers = new HashMap<Capabilities, String>(){
        {
            this.put(DesiredCapabilities.chrome(), "org.openqa.selenium.chrome.ChromeDriver");
            this.put(DesiredCapabilities.firefox(), "org.openqa.selenium.firefox.FirefoxDriver");
            this.put(DesiredCapabilities.htmlUnit(), "org.openqa.selenium.htmlunit.HtmlUnitDriver");
            this.put(DesiredCapabilities.internetExplorer(), "org.openqa.selenium.ie.InternetExplorerDriver");
        }
    };

    public DriverSessions() {
        this.registerDefaults(Platform.getCurrent());
    }

    private void registerDefaults(Platform current) {
        for (Map.Entry<Capabilities, String> entry : defaultDrivers.entrySet()) {
            Capabilities caps = entry.getKey();
            if (caps.getPlatform() != null && current.is(caps.getPlatform())) {
                this.registerDriver(caps, entry.getValue());
                continue;
            }
            if (caps.getPlatform() != null) continue;
            this.registerDriver(caps, entry.getValue());
        }
    }

    private void registerDriver(Capabilities caps, String className) {
        try {
            this.registerDriver(caps, Class.forName(className).asSubclass(WebDriver.class));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public SessionId newSession(Capabilities desiredCapabilities) throws Exception {
        Session session = new Session(this.factory, desiredCapabilities);
        SessionId sessionId = new SessionId(String.valueOf(System.currentTimeMillis()));
        sessionIdToDriver.put(sessionId, session);
        return sessionId;
    }

    public Session get(SessionId sessionId) {
        return sessionIdToDriver.get(sessionId);
    }

    public void deleteSession(SessionId sessionId) {
        sessionIdToDriver.remove(sessionId);
    }

    public void registerDriver(Capabilities capabilities, Class<? extends WebDriver> implementation) {
        this.factory.registerDriver(capabilities, implementation);
    }
}

