/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.jetty.util.IO;
import org.openqa.jetty.util.Resource;

public class ClassPathResource
extends Resource {
    String path;
    ByteArrayOutputStream os;

    public ClassPathResource(String path) {
        this.path = path;
        InputStream is = ClassPathResource.getSeleniumResourceAsStream(path);
        if (is != null) {
            this.os = new ByteArrayOutputStream();
            try {
                IO.copy(is, this.os);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static InputStream getSeleniumResourceAsStream(String resourceFile) {
        return ClassPathResource.class.getResourceAsStream(resourceFile);
    }

    @Override
    public Object getAssociate() {
        return super.getAssociate();
    }

    @Override
    public void release() {
    }

    @Override
    public boolean exists() {
        return this.os != null;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long lastModified() {
        return System.currentTimeMillis() + 31536000000L;
    }

    @Override
    public long length() {
        if (this.os != null) {
            return this.os.size();
        }
        return 0L;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    public File getFile() throws IOException {
        return null;
    }

    @Override
    public String getName() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.os != null) {
            return new ByteArrayInputStream(this.os.toByteArray());
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException, SecurityException {
        return null;
    }

    @Override
    public boolean delete() throws SecurityException {
        return false;
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        return false;
    }

    @Override
    public String[] list() {
        return new String[0];
    }

    @Override
    public Resource addPath(String pathParm) throws IOException, MalformedURLException {
        return new ClassPathResource(String.valueOf(this.path) + "/" + pathParm);
    }

    public String toString() {
        return this.getName();
    }
}

