/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.codec.http.QueryStringEncoder;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.openqa.selenium.safari.WebSocketConnection;

class SafariDriverChannelHandler
extends SimpleChannelUpstreamHandler {
    private final Logger log = Logger.getLogger(SafariDriverChannelHandler.class.getName());
    private static final String CLIENT_RESOURCE_PATH = String.format("/%s/client.js", SafariDriverChannelHandler.class.getPackage().getName().replace('.', '/'));
    private final BlockingQueue<WebSocketConnection> connectionQueue;
    private final int port;

    public SafariDriverChannelHandler(int port, BlockingQueue<WebSocketConnection> connectionQueue) {
        this.port = port;
        this.connectionQueue = connectionQueue;
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)e.getMessage();
            if ("websocket".equalsIgnoreCase(request.getHeader("Upgrade"))) {
                this.performWebSocketHandshake(ctx, request);
                return;
            }
            List<String> connectionHeaders = request.getHeaders("Connection");
            for (String header : connectionHeaders) {
                if (!"upgrade".equalsIgnoreCase(header)) continue;
                this.performWebSocketHandshake(ctx, request);
                return;
            }
            if (request.getMethod() != HttpMethod.GET && request.getMethod() != HttpMethod.HEAD) {
                this.sendNotAllowedResponse(ctx, request, HttpMethod.GET, HttpMethod.HEAD);
            } else if ("/favicon.ico".equals(request.getUri())) {
                this.handleFaviconRequest(ctx, request);
            } else {
                this.handleMainPageRequest(ctx, request);
            }
        } else {
            ctx.sendUpstream(e);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.log.log(Level.WARNING, e.getCause().getMessage(), e.getCause());
        e.getChannel().close();
    }

    private void handleFaviconRequest(ChannelHandlerContext ctx, HttpRequest request) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT);
        response.setHeader("Content-Length", 0);
        this.sendResponse(ctx, request, response);
    }

    private void handleMainPageRequest(ChannelHandlerContext ctx, HttpRequest request) throws IOException {
        DefaultHttpResponse response;
        String url = String.format("ws://localhost:%d", this.port);
        QueryStringDecoder queryString = new QueryStringDecoder(request.getUri());
        List<String> urls = queryString.getParameters().get("url");
        if (urls == null || urls.isEmpty() || !url.equals(urls.iterator().next())) {
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
            QueryStringEncoder encoder = new QueryStringEncoder("/connect.html");
            encoder.addParam("url", url);
            response.addHeader("Location", encoder.toString());
        } else {
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.setHeader("Content-Type", "text/html; charset=UTF-8");
            URL clientLibUrl = this.getClass().getResource(CLIENT_RESOURCE_PATH);
            String content = "<!DOCTYPE html>\n<script>" + Resources.toString(clientLibUrl, Charsets.UTF_8) + "</script>";
            response.setContent(ChannelBuffers.copiedBuffer((CharSequence)content, Charsets.UTF_8));
            response.setHeader("Content-Length", response.getContent().readableBytes());
        }
        this.sendResponse(ctx, request, response);
    }

    private void performWebSocketHandshake(final ChannelHandlerContext ctx, HttpRequest request) {
        boolean noExtensions;
        String noSubProtocols;
        this.log.fine("Performing WebSocket handshake");
        if (request.getMethod() != HttpMethod.GET) {
            this.log.fine("Invalid handshake method: " + request.getMethod() + "; must be GET");
            this.sendNotAllowedResponse(ctx, request, HttpMethod.GET);
            return;
        }
        String websocketUrl = String.format("ws://%s%s", request.getHeader("Host"), request.getUri());
        WebSocketServerHandshakerFactory handshakerFactory = new WebSocketServerHandshakerFactory(websocketUrl, noSubProtocols = null, noExtensions = false);
        WebSocketServerHandshaker handshaker = handshakerFactory.newHandshaker(request);
        if (handshaker == null) {
            handshakerFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
        } else {
            handshaker.handshake(ctx.getChannel(), request).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        SafariDriverChannelHandler.this.log.warning("WebSocket handshake failed");
                        return;
                    }
                    SafariDriverChannelHandler.this.log.info("Connection opened");
                    WebSocketConnection webSocketConnection = new WebSocketConnection(ctx.getChannel());
                    if (!SafariDriverChannelHandler.this.connectionQueue.offer(webSocketConnection)) {
                        SafariDriverChannelHandler.this.log.warning("Failed to register new WebSocket connection");
                    }
                }
            });
        }
    }

    private void sendNotAllowedResponse(ChannelHandlerContext ctx, HttpRequest request, HttpMethod ... allowedMethods) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.METHOD_NOT_ALLOWED);
        response.setHeader("Allow", Joiner.on(",").join(allowedMethods));
        response.setHeader("Content-Length", 0);
        this.sendResponse(ctx, request, response);
    }

    private void sendResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        ChannelFuture future = ctx.getChannel().write(response);
        if (!HttpHeaders.isKeepAlive(request) || response.getStatus().getCode() != 200) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }
}

