/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSCharsetRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSFontFaceRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSImportRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSMediaRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class CSSRule
extends SimpleScriptable {
    public static final short UNKNOWN_RULE = 0;
    public static final short STYLE_RULE = 1;
    public static final short CHARSET_RULE = 2;
    public static final short IMPORT_RULE = 3;
    public static final short MEDIA_RULE = 4;
    public static final short FONT_FACE_RULE = 5;
    public static final short PAGE_RULE = 6;
    private final CSSStyleSheet stylesheet_;
    private final org.w3c.dom.css.CSSRule rule_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME)})
    public CSSRule() {
        this.stylesheet_ = null;
        this.rule_ = null;
    }

    public static CSSRule create(CSSStyleSheet stylesheet, org.w3c.dom.css.CSSRule rule) {
        switch (rule.getType()) {
            case 1: {
                return new CSSStyleRule(stylesheet, (org.w3c.dom.css.CSSStyleRule)rule);
            }
            case 3: {
                return new CSSImportRule(stylesheet, (org.w3c.dom.css.CSSImportRule)rule);
            }
            case 2: {
                return new CSSCharsetRule(stylesheet, (org.w3c.dom.css.CSSCharsetRule)rule);
            }
            case 4: {
                return new CSSMediaRule(stylesheet, (org.w3c.dom.css.CSSMediaRule)rule);
            }
            case 5: {
                return new CSSFontFaceRule(stylesheet, (org.w3c.dom.css.CSSFontFaceRule)rule);
            }
        }
        throw new UnsupportedOperationException("CSSRule " + rule.getClass().getName() + " is not yet supported:" + rule.getCssText());
    }

    protected CSSRule(CSSStyleSheet stylesheet, org.w3c.dom.css.CSSRule rule) {
        this.stylesheet_ = stylesheet;
        this.rule_ = rule;
        this.setParentScope(stylesheet);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public short getType() {
        return this.rule_.getType();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public String getCssText() {
        return this.rule_.getCssText();
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void setCssText(String cssText) {
        this.rule_.setCssText(cssText);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public CSSStyleSheet getParentStyleSheet() {
        return this.stylesheet_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public CSSRule getParentRule() {
        org.w3c.dom.css.CSSRule parentRule = this.rule_.getParentRule();
        if (parentRule != null) {
            return CSSRule.create(this.stylesheet_, parentRule);
        }
        return null;
    }

    protected org.w3c.dom.css.CSSRule getRule() {
        return this.rule_;
    }
}

