/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.local;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import mx4j.remote.ConnectionResolver;
import mx4j.tools.remote.AbstractJMXConnector;
import mx4j.tools.remote.Connection;
import mx4j.tools.remote.ConnectionManager;
import mx4j.tools.remote.local.LocalConnection;
import mx4j.tools.remote.local.LocalConnectionMBeanServerConnection;

public class LocalConnector
extends AbstractJMXConnector {
    private transient Connection connection;

    public LocalConnector(JMXServiceURL url, Map environment) throws IOException {
        super(url);
    }

    protected void doConnect(Map environment) throws IOException, SecurityException {
        JMXServiceURL address = this.getAddress();
        String protocol = address.getProtocol();
        ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, environment);
        if (resolver == null) {
            throw new MalformedURLException("Unsupported protocol: " + protocol);
        }
        ConnectionManager server = (ConnectionManager)resolver.lookupClient(address, environment);
        server = (ConnectionManager)resolver.bindClient(server, environment);
        Object credentials = environment == null ? null : environment.get("jmx.remote.credentials");
        this.connection = server.connect(credentials);
    }

    protected void doClose() throws IOException {
        this.connection.close();
    }

    protected MBeanServerConnection doGetMBeanServerConnection(Subject delegate) throws IOException {
        return new LocalConnectionMBeanServerConnection((LocalConnection)((Object)this.connection), delegate);
    }

    public String getConnectionId() throws IOException {
        return this.connection.getConnectionId();
    }
}

