/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.javascript.ScriptableWithFallbackGetter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLOptionElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLSelectElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass
public class HTMLOptionsCollection
extends SimpleScriptable
implements ScriptableWithFallbackGetter {
    private HtmlSelect htmlSelect_;

    public HTMLOptionsCollection() {
    }

    public HTMLOptionsCollection(SimpleScriptable parentScope) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public void initialize(HtmlSelect select) {
        WebAssert.notNull("select", select);
        this.htmlSelect_ = select;
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (index < 0) {
            throw Context.reportRuntimeError("Index or size is negative");
        }
        Object response = index >= this.htmlSelect_.getOptionSize() ? Context.getUndefinedValue() : this.getScriptableFor(this.htmlSelect_.getOption(index));
        return response;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.htmlSelect_ == null) {
            super.put(name, start, value);
            return;
        }
        HTMLSelectElement parent = (HTMLSelectElement)this.htmlSelect_.getScriptObject();
        if (!this.has(name, start) && ScriptableObject.hasProperty((Scriptable)parent, name)) {
            ScriptableObject.putProperty((Scriptable)parent, name, value);
        } else {
            super.put(name, start, value);
        }
    }

    @Override
    public Object getWithFallback(String name) {
        if (!this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECT_OPTIONS_HAS_CHILDNODES_PROPERTY) && "childNodes".equals(name)) {
            return NOT_FOUND;
        }
        HTMLSelectElement select = (HTMLSelectElement)this.htmlSelect_.getScriptObject();
        return ScriptableObject.getProperty((Scriptable)select, name);
    }

    @JsxFunction
    public Object item(int index) {
        return this.get(index, null);
    }

    @Override
    public void put(int index, Scriptable start, Object newValue) {
        if (newValue == null) {
            this.htmlSelect_.removeOption(index);
        } else {
            HTMLOptionElement option = (HTMLOptionElement)newValue;
            HtmlOption htmlOption = option.getDomNodeOrNull();
            if (index >= this.getLength()) {
                this.htmlSelect_.appendOption(htmlOption);
            } else {
                this.htmlSelect_.replaceOption(index, htmlOption);
            }
        }
        if (this.getLength() == 1 && !this.htmlSelect_.isMultipleSelectEnabled()) {
            ((HTMLSelectElement)this.htmlSelect_.getScriptObject()).setSelectedIndex(0);
        }
    }

    @JsxGetter
    public int getLength() {
        return this.htmlSelect_.getOptionSize();
    }

    @JsxSetter
    public void setLength(int newLength) {
        int currentLength = this.htmlSelect_.getOptionSize();
        if (currentLength > newLength) {
            this.htmlSelect_.setOptionSize(newLength);
        } else {
            for (int i = currentLength; i < newLength; ++i) {
                HtmlOption option = (HtmlOption)HTMLParser.getFactory("option").createElement(this.htmlSelect_.getPage(), "option", null);
                this.htmlSelect_.appendOption(option);
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.GENERATED_88)) continue;
                option.appendChild(new DomText(option.getPage(), ""));
            }
        }
    }

    @JsxFunction
    public void add(Object newOptionObject, Object newIndex) {
        int index = this.getLength();
        if (newIndex instanceof Number) {
            index = ((Number)newIndex).intValue();
        }
        this.put(index, null, newOptionObject);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.FF, minVersion=10.0f)})
    public void remove(int index) {
        if (index < 0) {
            Context.reportRuntimeError("Invalid index: " + index);
        }
        if (index < this.getLength()) {
            this.htmlSelect_.removeOption(index);
        }
    }
}

