/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.safari.SafariDriverPipelineFactory;
import org.openqa.selenium.safari.WebSocketConnection;

class SafariDriverServer {
    private static final Logger LOG = Logger.getLogger(SafariDriverServer.class.getName());
    private final int port;
    private final BlockingQueue<WebSocketConnection> connections = new SynchronousQueue<WebSocketConnection>();
    private ServerBootstrap bootstrap;
    private Channel serverChannel;
    private ChannelGroup channelGroup;
    private int serverPort;

    public SafariDriverServer(int port) {
        Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (String)"Port must be >= 0: %d", (Object[])new Object[]{port});
        this.port = port;
    }

    public void start() {
        this.start(this.port);
    }

    private void start(int port) {
        if (this.serverChannel != null) {
            return;
        }
        this.serverPort = port == 0 ? PortProber.findFreePort() : port;
        this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.channelGroup = new DefaultChannelGroup();
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)new SafariDriverPipelineFactory(this.serverPort, this.connections, this.channelGroup));
        this.serverChannel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.serverPort));
        LOG.info("Server started on port " + this.serverPort);
    }

    public void stop() {
        if (this.bootstrap != null) {
            LOG.info("Stopping server");
            this.channelGroup.close().awaitUninterruptibly();
            this.serverChannel.close();
            this.bootstrap.releaseExternalResources();
            this.serverChannel = null;
            this.bootstrap = null;
        }
    }

    public boolean isRunning() {
        return this.bootstrap != null;
    }

    public String getUri() {
        Preconditions.checkState((this.serverChannel != null ? 1 : 0) != 0, (Object)"The server is not running; call #start()!");
        return "http://localhost:" + this.serverPort;
    }

    public WebSocketConnection getConnection(long timeout, TimeUnit unit) throws InterruptedException {
        return this.connections.poll(timeout, unit);
    }
}

