/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.openqa.selenium.safari.ConnectionClosedException;

class WebSocketConnection {
    private final Logger log = Logger.getLogger(WebSocketConnection.class.getName());
    private final Channel channel;
    private final AtomicReference<SettableFuture<String>> pendingResponse = new AtomicReference();

    public WebSocketConnection(Channel channel) {
        this.channel = channel;
        this.channel.getPipeline().addLast("websocket-handler", (ChannelHandler)new SimpleChannelUpstreamHandler(){

            public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
                if (!(e.getMessage() instanceof WebSocketFrame)) {
                    ctx.sendUpstream((ChannelEvent)e);
                } else {
                    WebSocketConnection.this.handleWebSocketFrame((WebSocketFrame)e.getMessage());
                }
            }

            public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
                WebSocketConnection.this.handleUncaughtException(e.getCause());
            }
        });
        this.channel.getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                SettableFuture response = WebSocketConnection.this.pendingResponse.getAndSet(null);
                if (null != response) {
                    response.setException((Throwable)((Object)new ConnectionClosedException("The underlying channel was closed")));
                }
            }
        });
    }

    private void handleUncaughtException(Throwable t) {
        SettableFuture response = this.pendingResponse.getAndSet(null);
        if (null != response) {
            response.setException(t);
        }
    }

    private void handleWebSocketFrame(WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            SettableFuture response = this.pendingResponse.getAndSet(null);
            if (null != response) {
                CloseWebSocketFrame f = (CloseWebSocketFrame)frame;
                response.setException((Throwable)((Object)new ConnectionClosedException("The driver socket was closed (" + f.getStatusCode() + ")")));
            }
        } else if (frame instanceof PingWebSocketFrame) {
            this.channel.write((Object)new PongWebSocketFrame(frame.getBinaryData()));
        } else if (frame instanceof TextWebSocketFrame) {
            SettableFuture response = this.pendingResponse.getAndSet(null);
            if (null != response) {
                response.set((Object)((TextWebSocketFrame)frame).getText());
            } else {
                this.log.warning("Unexpected message: " + ((TextWebSocketFrame)frame).getText());
            }
        } else {
            this.log.fine("Unexpected frame type: " + frame.getClass().getName());
        }
    }

    private void checkChannel() {
        Preconditions.checkState((this.channel.isOpen() && this.channel.isConnected() ? 1 : 0) != 0, (Object)"The WebSocket connection has been closed");
    }

    public ListenableFuture<String> send(String data) {
        this.checkChannel();
        final SettableFuture response = SettableFuture.create();
        response.addListener(new Runnable(){

            @Override
            public void run() {
                WebSocketConnection.this.pendingResponse.compareAndSet(response, null);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        if (this.pendingResponse.compareAndSet(null, (SettableFuture<String>)response)) {
            TextWebSocketFrame frame = new TextWebSocketFrame(data);
            this.channel.write((Object)frame).addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        response.setException(future.getCause());
                    }
                }
            });
            return response;
        }
        throw new IllegalStateException("Currently awaiting a response to a previous message");
    }

    public void close() {
        SettableFuture pending = this.pendingResponse.getAndSet(null);
        this.channel.write((Object)new CloseWebSocketFrame()).addListener(ChannelFutureListener.CLOSE);
        if (null != pending) {
            pending.cancel(true);
        }
    }
}

