/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.concurrent.BlockingQueue;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.openqa.selenium.safari.SafariDriverChannelHandler;
import org.openqa.selenium.safari.SafariDriverConnection;

class SafariDriverPipelineFactory
implements ChannelPipelineFactory {
    private final int port;
    private final BlockingQueue<SafariDriverConnection> connectionQueue;

    SafariDriverPipelineFactory(int port, BlockingQueue<SafariDriverConnection> connectionQueue) {
        this.port = port;
        this.connectionQueue = connectionQueue;
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(65536));
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("handler", (ChannelHandler)new SafariDriverChannelHandler(this.port, this.connectionQueue));
        return pipeline;
    }
}

