/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class StackFrame {
    private final String url;
    private final String functionName;
    private final int lineNumber;
    private final int columnNumber;

    private StackFrame(String scriptUrl, String function, int lineNumber, int columnNumber) {
        this.url = scriptUrl;
        this.functionName = function;
        this.lineNumber = Require.nonNegative((String)"lineNumber", (Integer)lineNumber);
        this.columnNumber = Require.nonNegative((String)"columnNumber", (Integer)columnNumber);
    }

    public String getUrl() {
        return this.url;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public static StackFrame fromJson(JsonInput input) {
        String url = null;
        String functionName = null;
        Integer lineNumber = null;
        Integer columnNumber = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "url": {
                    url = (String)input.read(String.class);
                    continue block12;
                }
                case "functionName": {
                    functionName = (String)input.read(String.class);
                    continue block12;
                }
                case "lineNumber": {
                    lineNumber = (Integer)input.read(Integer.class);
                    continue block12;
                }
                case "columnNumber": {
                    columnNumber = (Integer)input.read(Integer.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StackFrame((String)Require.nonNull((String)"url", url), (String)Require.nonNull((String)"functionName", functionName), (Integer)Require.nonNull((String)"lineNumber", (Object)lineNumber), (Integer)Require.nonNull((String)"columnNumber", (Object)columnNumber));
    }

    private Map<String, Object> toJson() {
        TreeMap<String, Object> toReturn = new TreeMap<String, Object>();
        toReturn.put("url", this.url);
        toReturn.put("functionName", this.functionName);
        toReturn.put("lineNumber", this.lineNumber);
        toReturn.put("columnNumber", this.columnNumber);
        return Collections.unmodifiableMap(toReturn);
    }
}

