/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import java.util.Optional;
import org.openqa.selenium.bidi.script.RealmType;
import org.openqa.selenium.bidi.script.WindowRealmInfo;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class RealmInfo {
    private final String realmId;
    private final String origin;
    private final RealmType realmType;

    public RealmInfo(String realmId, String origin, RealmType realmType) {
        this.realmId = realmId;
        this.origin = origin;
        this.realmType = realmType;
    }

    public static RealmInfo fromJson(JsonInput input) {
        String realmId = null;
        String origin = null;
        RealmType realmType = null;
        String browsingContext = null;
        String sandbox = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "type": {
                    String typeString = (String)input.readNonNull(String.class);
                    realmType = RealmType.findByName(typeString);
                    continue block14;
                }
                case "realm": {
                    realmId = (String)input.read(String.class);
                    continue block14;
                }
                case "origin": {
                    origin = (String)input.read(String.class);
                    continue block14;
                }
                case "context": {
                    browsingContext = (String)input.read(String.class);
                    continue block14;
                }
                case "sandbox": {
                    sandbox = (String)input.read(String.class);
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        if (realmType == RealmType.WINDOW) {
            return new WindowRealmInfo((String)Require.nonNull((String)"realmId", realmId), (String)Require.nonNull((String)"origin", origin), (RealmType)((Object)Require.nonNull((String)"realmType", (Object)((Object)realmType))), (String)Require.nonNull((String)"browsingContext", (Object)browsingContext), Optional.ofNullable(sandbox));
        }
        return new RealmInfo((String)Require.nonNull((String)"realmId", realmId), (String)Require.nonNull((String)"origin", origin), (RealmType)((Object)Require.nonNull((String)"realmType", (Object)((Object)realmType))));
    }

    public String getRealmId() {
        return this.realmId;
    }

    public String getOrigin() {
        return this.origin;
    }

    public RealmType getRealmType() {
        return this.realmType;
    }
}

