/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.script;

import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.bidi.script.StackTrace;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class ExceptionDetails {
    private final long columnNumber;
    private final RemoteValue exception;
    private final long lineNumber;
    private final StackTrace stacktrace;
    private final String text;

    public ExceptionDetails(long columnNumber, RemoteValue exception, long lineNumber, StackTrace stacktrace, String text) {
        this.columnNumber = columnNumber;
        this.exception = exception;
        this.lineNumber = lineNumber;
        this.stacktrace = stacktrace;
        this.text = text;
    }

    public static ExceptionDetails fromJson(JsonInput input) {
        long columnNumber = 0L;
        RemoteValue exception = null;
        long lineNumber = 0L;
        StackTrace stackTrace = null;
        String text = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "columnNumber": {
                    columnNumber = (Long)input.readNonNull(Long.class);
                    continue block14;
                }
                case "exception": {
                    exception = (RemoteValue)input.read(RemoteValue.class);
                    continue block14;
                }
                case "lineNumber": {
                    lineNumber = (Long)input.readNonNull(Long.class);
                    continue block14;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read(StackTrace.class);
                    continue block14;
                }
                case "text": {
                    text = (String)input.read(String.class);
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ExceptionDetails(columnNumber, (RemoteValue)Require.nonNull((String)"exception", exception), lineNumber, (StackTrace)Require.nonNull((String)"stackTrace", stackTrace), (String)Require.nonNull((String)"text", (Object)text));
    }

    public long getColumnNumber() {
        return this.columnNumber;
    }

    public RemoteValue getException() {
        return this.exception;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public StackTrace getStacktrace() {
        return this.stacktrace;
    }

    public String getText() {
        return this.text;
    }
}

