/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.network;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.network.Cookie;
import org.openqa.selenium.bidi.network.FetchTimingInfo;
import org.openqa.selenium.bidi.network.Header;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class RequestData {
    private final String requestId;
    private final String url;
    private final String method;
    private final List<Header> headers;
    private final List<Cookie> cookies;
    private final long headersSize;
    private final @Nullable Long bodySize;
    private final String destination;
    private final @Nullable String initiatorType;
    private final FetchTimingInfo timings;

    public RequestData(String requestId, String url, String method, List<Header> headers, List<Cookie> cookies, long headersSize, @Nullable Long bodySize, String destination, @Nullable String initiatorType, FetchTimingInfo timings) {
        this.requestId = requestId;
        this.url = url;
        this.method = method;
        this.headers = headers;
        this.cookies = cookies;
        this.headersSize = Require.nonNegative((String)"headersSize", (Long)headersSize);
        this.bodySize = bodySize;
        this.destination = destination;
        this.initiatorType = initiatorType;
        this.timings = timings;
    }

    public static RequestData fromJson(JsonInput input) {
        String requestId = null;
        String url = null;
        String method = null;
        List headers = new ArrayList();
        List cookies = new ArrayList();
        Long headersSize = null;
        Long bodySize = null;
        String destination = null;
        String initiatorType = null;
        FetchTimingInfo timings = null;
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "request": {
                    requestId = (String)input.read(String.class);
                    continue block24;
                }
                case "url": {
                    url = (String)input.read(String.class);
                    continue block24;
                }
                case "method": {
                    method = (String)input.read(String.class);
                    continue block24;
                }
                case "headers": {
                    headers = (List)input.read(new TypeToken<List<Header>>(){}.getType());
                    continue block24;
                }
                case "cookies": {
                    cookies = (List)input.read(new TypeToken<List<Cookie>>(){}.getType());
                    continue block24;
                }
                case "headersSize": {
                    headersSize = (Long)input.read(Long.class);
                    continue block24;
                }
                case "bodySize": {
                    bodySize = (Long)input.read(Long.class);
                    continue block24;
                }
                case "destination": {
                    destination = (String)input.read(String.class);
                    continue block24;
                }
                case "initiatorType": {
                    initiatorType = (String)input.read(String.class);
                    continue block24;
                }
                case "timings": {
                    timings = (FetchTimingInfo)input.read(FetchTimingInfo.class);
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestData((String)Require.nonNull((String)"requestId", requestId), (String)Require.nonNull((String)"url", url), (String)Require.nonNull((String)"method", (Object)method), (List)Require.nonNull((String)"headers", headers), (List)Require.nonNull((String)"cookies", cookies), (Long)Require.nonNull((String)"headersSize", (Object)headersSize), bodySize, (String)Require.nonNull((String)"destination", (Object)destination), initiatorType, (FetchTimingInfo)Require.nonNull((String)"timings", (Object)timings));
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public long getHeadersSize() {
        return this.headersSize;
    }

    public @Nullable Long getBodySize() {
        return this.bodySize;
    }

    public String getDestination() {
        return this.destination;
    }

    public @Nullable String getInitiatorType() {
        return this.initiatorType;
    }

    public FetchTimingInfo getTimings() {
        return this.timings;
    }
}

