/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.module;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.script.RemoteReference;
import org.openqa.selenium.interactions.Sequence;

public class Input {
    private final BiDi bidi;

    public Input(WebDriver driver) {
        this.bidi = ((HasBiDi)driver).getBiDi();
    }

    public void perform(String browsingContext, Collection<Sequence> actions) {
        List<Map> encodedActions = actions.stream().map(Sequence::encode).collect(Collectors.toList());
        encodedActions.forEach(encodedAction -> {
            String type = (String)encodedAction.get("type");
            if (type.equals("pointer") || type.equals("wheel")) {
                List actionList = (List)encodedAction.get("actions");
                actionList.stream().filter(action -> action.get("type").equals("pointerMove") || action.get("type").equals("scroll")).filter(action -> action.get("origin") instanceof WebElement).forEach(action -> {
                    Object element = action.get("origin");
                    try {
                        String id = (String)element.getClass().getMethod("getId", new Class[0]).invoke(element, new Object[0]);
                        action.put("origin", Map.of("type", "element", "element", Map.of("sharedId", id)));
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        });
        this.bidi.send(new Command("input.performActions", Map.of("context", browsingContext, "actions", encodedActions)));
    }

    public void release(String browsingContext) {
        this.bidi.send(new Command("input.releaseActions", Map.of("context", browsingContext)));
    }

    public void setFiles(String browsingContext, RemoteReference element, List<String> files) {
        this.bidi.send(new Command("input.setFiles", Map.of("context", browsingContext, "element", element.toJson(), "files", files)));
    }

    public void setFiles(String browsingContext, String elementId, List<String> files) {
        this.bidi.send(new Command("input.setFiles", Map.of("context", browsingContext, "element", new RemoteReference(RemoteReference.Type.SHARED_ID, elementId).toJson(), "files", files)));
    }

    public void setFiles(String browsingContext, RemoteReference element, String file) {
        this.setFiles(browsingContext, element, List.of(file));
    }

    public void setFiles(String browsingContext, String elementId, String file) {
        this.setFiles(browsingContext, elementId, List.of(file));
    }
}

