/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.log;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.log.GenericLogEntry;
import org.openqa.selenium.bidi.log.LogLevel;
import org.openqa.selenium.bidi.log.StackTrace;
import org.openqa.selenium.bidi.script.RemoteValue;
import org.openqa.selenium.bidi.script.Source;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class ConsoleLogEntry
extends GenericLogEntry {
    private final String method;
    private final List<RemoteValue> args;

    public ConsoleLogEntry(LogLevel level, Source source, String text, long timestamp, String type, String method, List<RemoteValue> args, @Nullable StackTrace stackTrace) {
        super(level, source, text, timestamp, type, stackTrace);
        this.method = method;
        this.args = args;
    }

    public String getMethod() {
        return this.method;
    }

    public List<RemoteValue> getArgs() {
        return this.args;
    }

    public static ConsoleLogEntry fromJson(JsonInput input) {
        LogLevel level = null;
        Source source = null;
        String text = null;
        Long timestamp = null;
        String type = null;
        String method = null;
        List args = null;
        StackTrace stackTrace = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "level": {
                    level = (LogLevel)((Object)input.read(LogLevel.class));
                    continue block20;
                }
                case "source": {
                    source = (Source)input.read(Source.class);
                    continue block20;
                }
                case "text": {
                    text = (String)input.read(String.class);
                    continue block20;
                }
                case "timestamp": {
                    timestamp = (Long)input.read(Long.class);
                    continue block20;
                }
                case "type": {
                    type = (String)input.read(String.class);
                    continue block20;
                }
                case "method": {
                    method = (String)input.read(String.class);
                    continue block20;
                }
                case "args": {
                    args = (List)input.read(new TypeToken<List<RemoteValue>>(){}.getType());
                    continue block20;
                }
                case "stackTrace": {
                    stackTrace = (StackTrace)input.read(StackTrace.class);
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ConsoleLogEntry((LogLevel)((Object)Require.nonNull((String)"Log level", level)), (Source)Require.nonNull((String)"Log source", source), (String)Require.nonNull((String)"Log text", (Object)text), (Long)Require.nonNull((String)"Log timestamp", (Object)timestamp), (String)Require.nonNull((String)"Log type", (Object)type), (String)Require.nonNull((String)"Log method", (Object)method), (List)Require.nonNull((String)"Log arguments", (Object)args), stackTrace);
    }
}

