/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.emulation;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.emulation.OverrideParameters;
import org.openqa.selenium.bidi.emulation.SetGeolocationOverrideParameters;
import org.openqa.selenium.bidi.emulation.SetNetworkConditionsParameters;
import org.openqa.selenium.bidi.emulation.SetScreenOrientationOverrideParameters;
import org.openqa.selenium.bidi.emulation.SetScreenSettingsOverrideParameters;
import org.openqa.selenium.bidi.emulation.SetScriptingEnabledParameters;
import org.openqa.selenium.bidi.emulation.SetTimezoneOverrideParameters;
import org.openqa.selenium.bidi.emulation.SetUserAgentOverrideParameters;
import org.openqa.selenium.internal.Require;

public class Emulation {
    private final HasBiDi driver;

    public Emulation(WebDriver driver) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver must implement BiDi interface");
        }
        this.driver = (HasBiDi)driver;
    }

    public void setGeolocationOverride(SetGeolocationOverrideParameters parameters) {
        this.send("emulation.setGeolocationOverride", parameters);
    }

    public void setTimezoneOverride(SetTimezoneOverrideParameters parameters) {
        this.send("emulation.setTimezoneOverride", parameters);
    }

    public void setScriptingEnabled(SetScriptingEnabledParameters parameters) {
        this.send("emulation.setScriptingEnabled", parameters);
    }

    public void setUserAgentOverride(SetUserAgentOverrideParameters parameters) {
        this.send("emulation.setUserAgentOverride", parameters);
    }

    public void setScreenOrientationOverride(SetScreenOrientationOverrideParameters parameters) {
        this.send("emulation.setScreenOrientationOverride", parameters);
    }

    public void setNetworkConditions(SetNetworkConditionsParameters parameters) {
        this.send("emulation.setNetworkConditions", parameters);
    }

    public void setScreenSettingsOverride(SetScreenSettingsOverrideParameters parameters) {
        this.send("emulation.setScreenSettingsOverride", parameters);
    }

    private void send(String command, OverrideParameters parameters) {
        Require.nonNull((String)"Parameters", (Object)parameters);
        this.driver.getBiDi().send(new Command(command, parameters.toMap()));
    }
}

