/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.bidi.browsingcontext.UserPromptType;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class UserPromptOpened {
    private final String browsingContextId;
    private final UserPromptType type;
    private final String message;
    private final @Nullable String defaultValue;

    private UserPromptOpened(String browsingContextId, UserPromptType type, String message, @Nullable String defaultValue) {
        this.browsingContextId = browsingContextId;
        this.type = type;
        this.message = message;
        this.defaultValue = defaultValue;
    }

    public static UserPromptOpened fromJson(JsonInput input) {
        String browsingContextId = null;
        UserPromptType type = null;
        String message = null;
        String defaultValue = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "context": {
                    browsingContextId = (String)input.read(String.class);
                    continue block12;
                }
                case "type": {
                    String userPromptType = (String)input.read(String.class);
                    type = UserPromptType.findByName(Objects.requireNonNull(userPromptType));
                    continue block12;
                }
                case "message": {
                    message = (String)input.read(String.class);
                    continue block12;
                }
                case "defaultValue": {
                    defaultValue = (String)input.read(String.class);
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new UserPromptOpened((String)Require.nonNull((String)"browsingContext", browsingContextId), (UserPromptType)((Object)Require.nonNull((String)"User prompt type", type)), (String)Require.nonNull((String)"User prompt message", (Object)message), defaultValue);
    }

    public String getBrowsingContextId() {
        return this.browsingContextId;
    }

    public UserPromptType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public @Nullable String getDefaultValue() {
        return this.defaultValue;
    }
}

