/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import java.lang.reflect.Type;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class BrowsingContextInfo {
    private static final Type LIST_OF_BROWSING_CONTEXT_INFO = new TypeToken<List<BrowsingContextInfo>>(){}.getType();
    private final String id;
    private final String url;
    private final @Nullable List<BrowsingContextInfo> children;
    private final String clientWindow;
    private final @Nullable String originalOpener;
    private final String userContext;
    private final @Nullable String parentBrowsingContext;

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public @Nullable List<BrowsingContextInfo> getChildren() {
        return this.children;
    }

    public String getClientWindow() {
        return this.clientWindow;
    }

    public @Nullable String getOriginalOpener() {
        return this.originalOpener;
    }

    public String getUserContext() {
        return this.userContext;
    }

    public @Nullable String getParentBrowsingContext() {
        return this.parentBrowsingContext;
    }

    public BrowsingContextInfo(String id, String url, @Nullable List<BrowsingContextInfo> children, String clientWindow, @Nullable String originalOpener, String userContext, @Nullable String parentBrowsingContext) {
        this.id = id;
        this.url = url;
        this.children = children;
        this.clientWindow = clientWindow;
        this.originalOpener = originalOpener;
        this.userContext = userContext;
        this.parentBrowsingContext = parentBrowsingContext;
    }

    public static BrowsingContextInfo fromJson(JsonInput input) {
        String id = null;
        String url = null;
        List children = null;
        String clientWindow = null;
        String originalOpener = null;
        String userContext = null;
        String parentBrowsingContext = null;
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "context": {
                    id = (String)input.read(String.class);
                    continue block18;
                }
                case "url": {
                    url = (String)input.read(String.class);
                    continue block18;
                }
                case "children": {
                    children = (List)input.read(LIST_OF_BROWSING_CONTEXT_INFO);
                    continue block18;
                }
                case "parent": {
                    parentBrowsingContext = (String)input.read(String.class);
                    continue block18;
                }
                case "clientWindow": {
                    clientWindow = (String)input.read(String.class);
                    continue block18;
                }
                case "originalOpener": {
                    originalOpener = (String)input.read(String.class);
                    continue block18;
                }
                case "userContext": {
                    userContext = (String)input.read(String.class);
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BrowsingContextInfo((String)Require.nonNull((String)"context", id), (String)Require.nonNull((String)"url", url), children, (String)Require.nonNull((String)"clientWindow", (Object)clientWindow), originalOpener, (String)Require.nonNull((String)"userContext", (Object)userContext), parentBrowsingContext);
    }

    public String toString() {
        return String.format("BrowsingContextInfo(%s %s)", this.id, this.url);
    }
}

