/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browser;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.internal.Require;

public class DownloadBehavior {
    private final boolean allowed;
    private final @Nullable Path destinationFolder;

    public static DownloadBehavior allowed(Path destinationFolder) {
        return new DownloadBehavior(true, destinationFolder);
    }

    public static DownloadBehavior denied() {
        return new DownloadBehavior(false, (Path)null);
    }

    public DownloadBehavior(boolean allowed, @Nullable String destinationFolder) {
        this(allowed, destinationFolder != null ? Paths.get(destinationFolder, new String[0]) : null);
    }

    public DownloadBehavior(boolean allowed, @Nullable Path destinationFolder) {
        this.allowed = allowed;
        this.destinationFolder = destinationFolder;
        if (allowed) {
            Require.nonNull((String)"destinationFolder", (Object)destinationFolder);
        } else {
            Require.isNull((String)"destinationFolder", (Object)destinationFolder);
        }
    }

    Map<String, String> toMap() {
        return this.allowed ? Map.of("type", "allowed", "destinationFolder", Objects.requireNonNull(this.destinationFolder).toAbsolutePath().toString()) : Map.of("type", "denied");
    }

    public String toString() {
        return String.format("DownloadBehavior{allowed=%s, destinationFolder=%s}", this.allowed, this.destinationFolder);
    }
}

