/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import com.google.auto.service.AutoService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.concurrent.Lazy;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;

@AutoService(value={AugmenterProvider.class})
public class BiDiProvider
implements AugmenterProvider<HasBiDi> {
    private static final Logger LOG = Logger.getLogger(BiDiProvider.class.getName());

    @Override
    public Predicate<Capabilities> isApplicable() {
        return caps -> this.getBiDiUrl((Capabilities)caps).isPresent();
    }

    @Override
    public Class<HasBiDi> getDescribedInterface() {
        return HasBiDi.class;
    }

    @Override
    public HasBiDi getImplementation(Capabilities caps, ExecuteMethod executeMethod) {
        final Lazy<BiDi> biDi = Lazy.lazy(() -> this.establishBiDiConnection(caps, executeMethod));
        LOG.log(Level.INFO, "WebDriver augmented with BiDi interface; connection will not be verified until first use.");
        return new HasBiDi(){

            @Override
            public Optional<BiDi> maybeGetBiDi() {
                return biDi.getIfInitialized();
            }

            @Override
            public BiDi getBiDi() {
                return (BiDi)biDi.get();
            }
        };
    }

    private BiDi establishBiDiConnection(Capabilities caps, ExecuteMethod executeMethod) {
        URI wsUri = this.getBiDiUrl(caps).orElseThrow(() -> new BiDiException("BiDi not supported"));
        ClientConfig clientConfig = ((RemoteExecuteMethod)executeMethod).getWrappedDriver().getClientConfig();
        HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
        ClientConfig wsConfig = clientConfig.baseUri(wsUri);
        HttpClient wsClient = clientFactory.createClient(wsConfig);
        Connection connection = new Connection(wsClient, wsUri.toString());
        return new BiDi(connection, wsConfig.wsTimeout());
    }

    private Optional<URI> getBiDiUrl(Capabilities caps) {
        Object biDiCapability = caps.getCapability("webSocketUrl");
        Optional<String> webSocketUrl = Optional.ofNullable((String)biDiCapability);
        return webSocketUrl.map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                throw new BiDiException("Invalid BiDi URL: " + uri, e);
            }
        });
    }
}

