/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.io.File;
import java.util.logging.Logger;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.remote.FileDetector;

@NullMarked
public class LocalFileDetector
implements FileDetector {
    private static final Logger LOG = Logger.getLogger(LocalFileDetector.class.getName());

    @Override
    public @Nullable File getLocalFile(CharSequence ... keys) {
        StringBuilder builder = new StringBuilder();
        for (CharSequence chars : keys) {
            builder.append(chars);
        }
        String filepath = builder.toString();
        if (filepath.isEmpty()) {
            return null;
        }
        File file = new File(filepath);
        File parentDir = file.getParentFile();
        if (parentDir == null) {
            parentDir = new File(".");
        }
        File toUpload = new File(parentDir, file.getName());
        LOG.fine("Detected local file: " + toUpload.exists());
        return toUpload.exists() && toUpload.isFile() ? toUpload : null;
    }
}

