/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.CommandPayload;

public interface DriverCommand {
    public static final String GET_ALL_SESSIONS = "getAllSessions";
    public static final String GET_CAPABILITIES = "getCapabilities";
    public static final String NEW_SESSION = "newSession";
    public static final String STATUS = "status";
    public static final String CLOSE = "close";
    public static final String QUIT = "quit";
    public static final String GET = "get";
    public static final String GO_BACK = "goBack";
    public static final String GO_FORWARD = "goForward";
    public static final String REFRESH = "refresh";
    public static final String ADD_COOKIE = "addCookie";
    public static final String GET_ALL_COOKIES = "getCookies";
    public static final String GET_COOKIE = "getCookie";
    public static final String DELETE_COOKIE = "deleteCookie";
    public static final String DELETE_ALL_COOKIES = "deleteAllCookies";
    public static final String FIND_ELEMENT = "findElement";
    public static final String FIND_ELEMENTS = "findElements";
    public static final String FIND_CHILD_ELEMENT = "findChildElement";
    public static final String FIND_CHILD_ELEMENTS = "findChildElements";
    public static final String CLEAR_ELEMENT = "clearElement";
    public static final String CLICK_ELEMENT = "clickElement";
    public static final String SEND_KEYS_TO_ELEMENT = "sendKeysToElement";
    public static final String SEND_KEYS_TO_ACTIVE_ELEMENT = "sendKeysToActiveElement";
    public static final String SUBMIT_ELEMENT = "submitElement";
    public static final String UPLOAD_FILE = "uploadFile";
    public static final String GET_CURRENT_WINDOW_HANDLE = "getCurrentWindowHandle";
    public static final String GET_WINDOW_HANDLES = "getWindowHandles";
    public static final String GET_CURRENT_CONTEXT_HANDLE = "getCurrentContextHandle";
    public static final String GET_CONTEXT_HANDLES = "getContextHandles";
    public static final String SWITCH_TO_WINDOW = "switchToWindow";
    public static final String SWITCH_TO_NEW_WINDOW = "newWindow";
    public static final String SWITCH_TO_CONTEXT = "switchToContext";
    public static final String SWITCH_TO_FRAME = "switchToFrame";
    public static final String SWITCH_TO_PARENT_FRAME = "switchToParentFrame";
    public static final String GET_ACTIVE_ELEMENT = "getActiveElement";
    public static final String GET_CURRENT_URL = "getCurrentUrl";
    public static final String GET_PAGE_SOURCE = "getPageSource";
    public static final String GET_TITLE = "getTitle";
    public static final String EXECUTE_SCRIPT = "executeScript";
    public static final String EXECUTE_ASYNC_SCRIPT = "executeAsyncScript";
    public static final String GET_ELEMENT_TEXT = "getElementText";
    public static final String GET_ELEMENT_TAG_NAME = "getElementTagName";
    public static final String IS_ELEMENT_SELECTED = "isElementSelected";
    public static final String IS_ELEMENT_ENABLED = "isElementEnabled";
    public static final String IS_ELEMENT_DISPLAYED = "isElementDisplayed";
    public static final String GET_ELEMENT_RECT = "getElementRect";
    public static final String GET_ELEMENT_LOCATION = "getElementLocation";
    public static final String GET_ELEMENT_LOCATION_ONCE_SCROLLED_INTO_VIEW = "getElementLocationOnceScrolledIntoView";
    public static final String GET_ELEMENT_SIZE = "getElementSize";
    public static final String GET_ELEMENT_ATTRIBUTE = "getElementAttribute";
    public static final String GET_ELEMENT_PROPERTY = "getElementProperty";
    public static final String GET_ELEMENT_VALUE_OF_CSS_PROPERTY = "getElementValueOfCssProperty";
    public static final String ELEMENT_EQUALS = "elementEquals";
    public static final String SCREENSHOT = "screenshot";
    public static final String ELEMENT_SCREENSHOT = "elementScreenshot";
    public static final String ACCEPT_ALERT = "acceptAlert";
    public static final String DISMISS_ALERT = "dismissAlert";
    public static final String GET_ALERT_TEXT = "getAlertText";
    public static final String SET_ALERT_VALUE = "setAlertValue";
    public static final String SET_ALERT_CREDENTIALS = "setAlertCredentials";
    public static final String SET_TIMEOUT = "setTimeout";
    public static final String IMPLICITLY_WAIT = "implicitlyWait";
    public static final String SET_SCRIPT_TIMEOUT = "setScriptTimeout";
    public static final String GET_LOCATION = "getLocation";
    public static final String SET_LOCATION = "setLocation";
    public static final String GET_APP_CACHE = "getAppCache";
    public static final String GET_APP_CACHE_STATUS = "getStatus";
    public static final String CLEAR_APP_CACHE = "clearAppCache";
    public static final String IS_BROWSER_ONLINE = "isBrowserOnline";
    public static final String SET_BROWSER_ONLINE = "setBrowserOnline";
    public static final String GET_LOCAL_STORAGE_ITEM = "getLocalStorageItem";
    public static final String GET_LOCAL_STORAGE_KEYS = "getLocalStorageKeys";
    public static final String SET_LOCAL_STORAGE_ITEM = "setLocalStorageItem";
    public static final String REMOVE_LOCAL_STORAGE_ITEM = "removeLocalStorageItem";
    public static final String CLEAR_LOCAL_STORAGE = "clearLocalStorage";
    public static final String GET_LOCAL_STORAGE_SIZE = "getLocalStorageSize";
    public static final String GET_SESSION_STORAGE_ITEM = "getSessionStorageItem";
    public static final String GET_SESSION_STORAGE_KEYS = "getSessionStorageKey";
    public static final String SET_SESSION_STORAGE_ITEM = "setSessionStorageItem";
    public static final String REMOVE_SESSION_STORAGE_ITEM = "removeSessionStorageItem";
    public static final String CLEAR_SESSION_STORAGE = "clearSessionStorage";
    public static final String GET_SESSION_STORAGE_SIZE = "getSessionStorageSize";
    public static final String SET_SCREEN_ORIENTATION = "setScreenOrientation";
    public static final String GET_SCREEN_ORIENTATION = "getScreenOrientation";
    public static final String SET_SCREEN_ROTATION = "setScreenRotation";
    public static final String GET_SCREEN_ROTATION = "getScreenRotation";
    public static final String ACTIONS = "actions";
    public static final String CLEAR_ACTIONS_STATE = "clearActionState";
    public static final String CLICK = "mouseClick";
    public static final String DOUBLE_CLICK = "mouseDoubleClick";
    public static final String MOUSE_DOWN = "mouseButtonDown";
    public static final String MOUSE_UP = "mouseButtonUp";
    public static final String MOVE_TO = "mouseMoveTo";
    public static final String IME_GET_AVAILABLE_ENGINES = "imeGetAvailableEngines";
    public static final String IME_GET_ACTIVE_ENGINE = "imeGetActiveEngine";
    public static final String IME_IS_ACTIVATED = "imeIsActivated";
    public static final String IME_DEACTIVATE = "imeDeactivate";
    public static final String IME_ACTIVATE_ENGINE = "imeActivateEngine";
    public static final String TOUCH_SINGLE_TAP = "touchSingleTap";
    public static final String TOUCH_DOWN = "touchDown";
    public static final String TOUCH_UP = "touchUp";
    public static final String TOUCH_MOVE = "touchMove";
    public static final String TOUCH_SCROLL = "touchScroll";
    public static final String TOUCH_DOUBLE_TAP = "touchDoubleTap";
    public static final String TOUCH_LONG_PRESS = "touchLongPress";
    public static final String TOUCH_FLICK = "touchFlick";
    public static final String SET_CURRENT_WINDOW_POSITION = "setWindowPosition";
    public static final String GET_CURRENT_WINDOW_POSITION = "getWindowPosition";
    public static final String SET_CURRENT_WINDOW_SIZE = "setCurrentWindowSize";
    public static final String GET_CURRENT_WINDOW_SIZE = "getCurrentWindowSize";
    public static final String MAXIMIZE_CURRENT_WINDOW = "maximizeCurrentWindow";
    public static final String FULLSCREEN_CURRENT_WINDOW = "fullscreenCurrentWindow";
    public static final String GET_AVAILABLE_LOG_TYPES = "getAvailableLogTypes";
    public static final String GET_LOG = "getLog";
    public static final String GET_SESSION_LOGS = "getSessionLogs";
    public static final String GET_NETWORK_CONNECTION = "getNetworkConnection";
    public static final String SET_NETWORK_CONNECTION = "setNetworkConnection";
    public static final String ADD_VIRTUAL_AUTHENTICATOR = "addVirtualAuthenticator";
    public static final String REMOVE_VIRTUAL_AUTHENTICATOR = "removeVirtualAuthenticator";
    public static final String ADD_CREDENTIAL = "addCredential";
    public static final String GET_CREDENTIALS = "getCredentials";
    public static final String REMOVE_CREDENTIAL = "removeCredential";
    public static final String REMOVE_ALL_CREDENTIALS = "removeAllCredentials";
    public static final String SET_USER_VERIFIED = "setUserVerified";

    public static CommandPayload NEW_SESSION(Capabilities capabilities) {
        return new CommandPayload(NEW_SESSION, (Map<String, ?>)ImmutableMap.of((Object)"desiredCapabilities", (Object)capabilities));
    }

    public static CommandPayload GET(String url) {
        return new CommandPayload(GET, (Map<String, ?>)ImmutableMap.of((Object)"url", (Object)url));
    }

    public static CommandPayload ADD_COOKIE(Cookie cookie) {
        return new CommandPayload(ADD_COOKIE, (Map<String, ?>)ImmutableMap.of((Object)"cookie", (Object)cookie));
    }

    public static CommandPayload DELETE_COOKIE(String name) {
        return new CommandPayload(DELETE_COOKIE, (Map<String, ?>)ImmutableMap.of((Object)"name", (Object)name));
    }

    public static CommandPayload FIND_ELEMENT(String strategy, String value) {
        return new CommandPayload(FIND_ELEMENT, (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)strategy, (Object)"value", (Object)value));
    }

    public static CommandPayload FIND_ELEMENTS(String strategy, String value) {
        return new CommandPayload(FIND_ELEMENTS, (Map<String, ?>)ImmutableMap.of((Object)"using", (Object)strategy, (Object)"value", (Object)value));
    }

    public static CommandPayload FIND_CHILD_ELEMENT(String id, String strategy, String value) {
        return new CommandPayload(FIND_CHILD_ELEMENT, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id, (Object)"using", (Object)strategy, (Object)"value", (Object)value));
    }

    public static CommandPayload FIND_CHILD_ELEMENTS(String id, String strategy, String value) {
        return new CommandPayload(FIND_CHILD_ELEMENTS, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id, (Object)"using", (Object)strategy, (Object)"value", (Object)value));
    }

    public static CommandPayload CLEAR_ELEMENT(String id) {
        return new CommandPayload(CLEAR_ELEMENT, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload CLICK_ELEMENT(String id) {
        return new CommandPayload(CLICK_ELEMENT, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload SEND_KEYS_TO_ELEMENT(String id, CharSequence[] keysToSend) {
        return new CommandPayload(SEND_KEYS_TO_ELEMENT, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id, (Object)"value", (Object)keysToSend));
    }

    public static CommandPayload SUBMIT_ELEMENT(String id) {
        return new CommandPayload(SUBMIT_ELEMENT, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload UPLOAD_FILE(String file) {
        return new CommandPayload(UPLOAD_FILE, (Map<String, ?>)ImmutableMap.of((Object)"file", (Object)file));
    }

    public static CommandPayload SWITCH_TO_WINDOW(String windowHandleOrName) {
        return new CommandPayload(SWITCH_TO_WINDOW, (Map<String, ?>)ImmutableMap.of((Object)"handle", (Object)windowHandleOrName));
    }

    public static CommandPayload SWITCH_TO_NEW_WINDOW(WindowType typeHint) {
        return new CommandPayload(SWITCH_TO_NEW_WINDOW, (Map<String, ?>)ImmutableMap.of((Object)"type", (Object)typeHint.toString()));
    }

    public static CommandPayload SWITCH_TO_FRAME(Object frame) {
        return new CommandPayload(SWITCH_TO_FRAME, Collections.singletonMap("id", frame));
    }

    public static CommandPayload EXECUTE_SCRIPT(String script, List<Object> args) {
        return new CommandPayload(EXECUTE_SCRIPT, (Map<String, ?>)ImmutableMap.of((Object)"script", (Object)script, (Object)"args", args));
    }

    public static CommandPayload EXECUTE_ASYNC_SCRIPT(String script, List<Object> args) {
        return new CommandPayload(EXECUTE_ASYNC_SCRIPT, (Map<String, ?>)ImmutableMap.of((Object)"script", (Object)script, (Object)"args", args));
    }

    public static CommandPayload GET_ELEMENT_TEXT(String id) {
        return new CommandPayload(GET_ELEMENT_TEXT, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload GET_ELEMENT_TAG_NAME(String id) {
        return new CommandPayload(GET_ELEMENT_TAG_NAME, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload IS_ELEMENT_SELECTED(String id) {
        return new CommandPayload(IS_ELEMENT_SELECTED, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload IS_ELEMENT_ENABLED(String id) {
        return new CommandPayload(IS_ELEMENT_ENABLED, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload IS_ELEMENT_DISPLAYED(String id) {
        return new CommandPayload(IS_ELEMENT_DISPLAYED, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload GET_ELEMENT_RECT(String id) {
        return new CommandPayload(GET_ELEMENT_RECT, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload GET_ELEMENT_LOCATION(String id) {
        return new CommandPayload(GET_ELEMENT_LOCATION, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload GET_ELEMENT_LOCATION_ONCE_SCROLLED_INTO_VIEW(String id) {
        return new CommandPayload(GET_ELEMENT_LOCATION_ONCE_SCROLLED_INTO_VIEW, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload GET_ELEMENT_SIZE(String id) {
        return new CommandPayload(GET_ELEMENT_SIZE, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload GET_ELEMENT_ATTRIBUTE(String id, String name) {
        return new CommandPayload(GET_ELEMENT_ATTRIBUTE, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id, (Object)"name", (Object)name));
    }

    public static CommandPayload GET_ELEMENT_VALUE_OF_CSS_PROPERTY(String id, String name) {
        return new CommandPayload(GET_ELEMENT_VALUE_OF_CSS_PROPERTY, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id, (Object)"propertyName", (Object)name));
    }

    public static CommandPayload ELEMENT_SCREENSHOT(String id) {
        return new CommandPayload(ELEMENT_SCREENSHOT, (Map<String, ?>)ImmutableMap.of((Object)"id", (Object)id));
    }

    public static CommandPayload SET_ALERT_VALUE(String keysToSend) {
        return new CommandPayload(SET_ALERT_VALUE, (Map<String, ?>)ImmutableMap.of((Object)"text", (Object)keysToSend));
    }

    public static CommandPayload SET_IMPLICIT_WAIT_TIMEOUT(long time, TimeUnit unit) {
        return new CommandPayload(SET_TIMEOUT, (Map<String, ?>)ImmutableMap.of((Object)"implicit", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
    }

    public static CommandPayload SET_SCRIPT_TIMEOUT(long time, TimeUnit unit) {
        return new CommandPayload(SET_TIMEOUT, (Map<String, ?>)ImmutableMap.of((Object)"script", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
    }

    public static CommandPayload SET_PAGE_LOAD_TIMEOUT(long time, TimeUnit unit) {
        return new CommandPayload(SET_TIMEOUT, (Map<String, ?>)ImmutableMap.of((Object)"pageLoad", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
    }

    public static CommandPayload ACTIONS(Collection<Sequence> actions) {
        return new CommandPayload(ACTIONS, (Map<String, ?>)ImmutableMap.of((Object)ACTIONS, actions));
    }

    public static CommandPayload IME_ACTIVATE_ENGINE(String engine) {
        return new CommandPayload(SET_ALERT_VALUE, (Map<String, ?>)ImmutableMap.of((Object)"engine", (Object)engine));
    }

    public static CommandPayload SET_CURRENT_WINDOW_POSITION(Point targetPosition) {
        return new CommandPayload(SET_CURRENT_WINDOW_POSITION, (Map<String, ?>)ImmutableMap.of((Object)"x", (Object)targetPosition.x, (Object)"y", (Object)targetPosition.y));
    }

    public static CommandPayload GET_CURRENT_WINDOW_POSITION() {
        return new CommandPayload(GET_CURRENT_WINDOW_POSITION, (Map<String, ?>)ImmutableMap.of((Object)"windowHandle", (Object)"current"));
    }

    public static CommandPayload SET_CURRENT_WINDOW_SIZE(Dimension targetSize) {
        return new CommandPayload(SET_CURRENT_WINDOW_SIZE, (Map<String, ?>)ImmutableMap.of((Object)"width", (Object)targetSize.width, (Object)"height", (Object)targetSize.height));
    }
}

