/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.ElementNotSelectableException;
import org.openqa.selenium.ImeActivationFailedException;
import org.openqa.selenium.ImeNotAvailableException;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchCookieException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.InvalidCoordinatesException;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.remote.ScreenshotException;

public class ErrorCodes {
    @Beta
    public static final String SUCCESS_STRING = "success";
    public static final int SUCCESS = 0;
    public static final int NO_SUCH_SESSION = 6;
    public static final int NO_SUCH_ELEMENT = 7;
    public static final int NO_SUCH_FRAME = 8;
    public static final int UNKNOWN_COMMAND = 9;
    public static final int STALE_ELEMENT_REFERENCE = 10;
    public static final int ELEMENT_NOT_VISIBLE = 11;
    public static final int INVALID_ELEMENT_STATE = 12;
    public static final int UNHANDLED_ERROR = 13;
    public static final int ELEMENT_NOT_SELECTABLE = 15;
    public static final int JAVASCRIPT_ERROR = 17;
    public static final int XPATH_LOOKUP_ERROR = 19;
    public static final int TIMEOUT = 21;
    public static final int NO_SUCH_WINDOW = 23;
    public static final int INVALID_COOKIE_DOMAIN = 24;
    public static final int UNABLE_TO_SET_COOKIE = 25;
    public static final int UNEXPECTED_ALERT_PRESENT = 26;
    public static final int NO_ALERT_PRESENT = 27;
    public static final int ASYNC_SCRIPT_TIMEOUT = 28;
    public static final int INVALID_ELEMENT_COORDINATES = 29;
    public static final int IME_NOT_AVAILABLE = 30;
    public static final int IME_ENGINE_ACTIVATION_FAILED = 31;
    public static final int INVALID_SELECTOR_ERROR = 32;
    public static final int SESSION_NOT_CREATED = 33;
    public static final int MOVE_TARGET_OUT_OF_BOUNDS = 34;
    public static final int INVALID_XPATH_SELECTOR = 51;
    public static final int INVALID_XPATH_SELECTOR_RETURN_TYPER = 52;
    public static final int METHOD_NOT_ALLOWED = 405;
    private static final Logger log = Logger.getLogger(ErrorCodes.class.getName());
    private static final ImmutableMap<Integer, ImmutableSet<StatusTuple>> ALL_CODES = ImmutableMap.builder().put((Object)200, (Object)ImmutableSortedSet.naturalOrder().add((Object)new StatusTuple("success", 0, null)).build()).put((Object)400, (Object)ImmutableSortedSet.naturalOrder().add((Object)new StatusTuple("element not selectable", 15, ElementNotSelectableException.class)).add((Object)new StatusTuple("element not interactable", 12, ElementNotInteractableException.class)).add((Object)new StatusTuple("invalid argument", 13, InvalidArgumentException.class)).add((Object)new StatusTuple("invalid cookie domain", 24, InvalidCookieDomainException.class)).add((Object)new StatusTuple("invalid element coordinates", 29, InvalidCoordinatesException.class)).add((Object)new StatusTuple("invalid element state", 12, InvalidElementStateException.class)).add((Object)new StatusTuple("invalid selector", 32, InvalidSelectorException.class, 32)).add((Object)new StatusTuple("invalid selector", 51, InvalidSelectorException.class, 32)).add((Object)new StatusTuple("invalid selector", 52, InvalidSelectorException.class, 32)).add((Object)new StatusTuple("invalid selector", 19, InvalidSelectorException.class, 32)).add((Object)new StatusTuple("no such alert", 27, NoAlertPresentException.class)).add((Object)new StatusTuple("no such frame", 8, NoSuchFrameException.class)).add((Object)new StatusTuple("no such window", 23, NoSuchWindowException.class)).add((Object)new StatusTuple("stale element reference", 10, StaleElementReferenceException.class)).build()).put((Object)404, (Object)ImmutableSortedSet.naturalOrder().add((Object)new StatusTuple("invalid session id", 6, NoSuchSessionException.class)).add((Object)new StatusTuple("no such cookie", 13, NoSuchCookieException.class)).add((Object)new StatusTuple("no such element", 7, NoSuchElementException.class)).add((Object)new StatusTuple("unknown command", 9, UnsupportedCommandException.class, 13)).build()).put((Object)405, (Object)ImmutableSortedSet.naturalOrder().add((Object)new StatusTuple("unknown method", 405, UnsupportedCommandException.class, 13)).build()).put((Object)408, (Object)ImmutableSortedSet.naturalOrder().add((Object)new StatusTuple("script timeout", 28, TimeoutException.class, 21)).add((Object)new StatusTuple("timeout", 21, TimeoutException.class, 21)).build()).put((Object)500, (Object)ImmutableSortedSet.naturalOrder().add((Object)new StatusTuple("javascript error", 17, WebDriverException.class, 13)).add((Object)new StatusTuple("move target out of bounds", 34, MoveTargetOutOfBoundsException.class)).add((Object)new StatusTuple("session not created", 33, SessionNotCreatedException.class)).add((Object)new StatusTuple("unable to set cookie", 25, UnableToSetCookieException.class)).add((Object)new StatusTuple("unable to capture screen", 13, ScreenshotException.class)).add((Object)new StatusTuple("unexpected alert open", 26, UnhandledAlertException.class)).add((Object)new StatusTuple("unknown error", 13, WebDriverException.class, 13)).add((Object)new StatusTuple("unsupported operation", 405, UnsupportedCommandException.class, 13)).add((Object)new StatusTuple("unsupported operation", 30, ImeNotAvailableException.class)).add((Object)new StatusTuple("unsupported operation", 31, ImeActivationFailedException.class)).build()).build();
    private static final Map<Integer, String> JSON_TO_W3C = ALL_CODES.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(StatusTuple::asStatus, StatusTuple::asState, (key1, key2) -> key1));
    private static final Map<String, Integer> W3C_TO_JSON = ALL_CODES.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(StatusTuple::asState, StatusTuple::asStatus, (key1, key2) -> key1));
    private static final Map<Integer, Map<String, Integer>> HTTP_TO_STATE_AND_STATUS = ALL_CODES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ImmutableSet)entry.getValue()).stream().collect(Collectors.toMap(StatusTuple::asState, StatusTuple::asStatus, (key1, key2) -> key1))));
    private static final Map<String, Class<? extends WebDriverException>> STATE_TO_EXCEPTION = ALL_CODES.values().stream().flatMap(Collection::stream).filter(tuple -> tuple.getException() != null).collect(Collectors.toMap(StatusTuple::asState, StatusTuple::getException, (key1, key2) -> key1));

    public String toState(Integer status) {
        return JSON_TO_W3C.getOrDefault(status, "unknown error");
    }

    public int toStatus(String webdriverState, Optional<Integer> httpStatus) {
        if (httpStatus.isPresent()) {
            Map<String, Integer> tuples = HTTP_TO_STATE_AND_STATUS.get(httpStatus.get());
            if (tuples != null) {
                Integer value = tuples.get(webdriverState);
                if (value != null) {
                    return value;
                }
                log.info(String.format("HTTP Status: '%d' -> no JSON status mapping for '%s'", httpStatus.get(), webdriverState));
            } else {
                log.info(String.format("No JSON status codes found for HTTP status: '%d' -> ", httpStatus.get()));
            }
        }
        return W3C_TO_JSON.getOrDefault(webdriverState, 13);
    }

    public Class<? extends WebDriverException> getExceptionType(int statusCode) {
        return this.getExceptionType(this.toState(statusCode));
    }

    public Class<? extends WebDriverException> getExceptionType(String webdriverState) {
        return STATE_TO_EXCEPTION.getOrDefault(webdriverState, WebDriverException.class);
    }

    public int toStatusCode(Throwable e) {
        if (e == null) {
            return 0;
        }
        if (ImeNotAvailableException.class.equals(e.getClass())) {
            return 30;
        }
        if (ImeActivationFailedException.class.equals(e.getClass())) {
            return 31;
        }
        Set possibleMatches = ALL_CODES.values().stream().flatMap(Collection::stream).filter(tuple -> tuple.getException() != null).filter(tuple -> ((StatusTuple)tuple).associatedException.isAssignableFrom(e.getClass())).map(StatusTuple::getStatusFromException).collect(Collectors.toSet());
        return (Integer)Preconditions.checkNotNull((Object)Iterables.getFirst(possibleMatches, (Object)13));
    }

    public boolean isMappableError(Throwable rootCause) {
        if (rootCause == null) {
            return false;
        }
        Set possibleMatches = ALL_CODES.values().stream().flatMap(Collection::stream).filter(tuple -> tuple.getException() != null).filter(tuple -> ((StatusTuple)tuple).associatedException.isAssignableFrom(rootCause.getClass())).map(StatusTuple::asStatus).collect(Collectors.toSet());
        return !possibleMatches.isEmpty();
    }

    private static class StatusTuple
    implements Comparable<StatusTuple> {
        private final String w3cState;
        private final int jsonStatus;
        private final Class<? extends WebDriverException> associatedException;
        private final int seleniumExceptionToResponseCode;

        public StatusTuple(String w3cState, int jsonStatus, Class<? extends WebDriverException> ex) {
            this(w3cState, jsonStatus, ex, jsonStatus);
        }

        public StatusTuple(String w3cState, int jsonStatus, Class<? extends WebDriverException> ex, int seleniumExceptionToResponseCode) {
            this.w3cState = w3cState;
            this.jsonStatus = jsonStatus;
            this.associatedException = ex;
            this.seleniumExceptionToResponseCode = seleniumExceptionToResponseCode;
        }

        public int asStatus() {
            return this.jsonStatus;
        }

        public String asState() {
            return this.w3cState;
        }

        public int getStatusFromException() {
            return this.seleniumExceptionToResponseCode;
        }

        @Override
        public int compareTo(StatusTuple that) {
            return ComparisonChain.start().compare((Comparable)((Object)this.w3cState), (Comparable)((Object)that.w3cState)).compare(this.jsonStatus, that.jsonStatus).result();
        }

        public Class<? extends WebDriverException> getException() {
            return this.associatedException;
        }
    }
}

