/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import com.thoughtworks.selenium.Selenium;
import org.openqa.selenium.server.htmlrunner.CoreStep;
import org.openqa.selenium.server.htmlrunner.TestState;

abstract class NextStepDecorator {
    static NextStepDecorator IDENTITY = new NextStepDecorator(null){

        @Override
        public boolean isOkayToContinueTest() {
            return true;
        }
    };
    private final Throwable cause;

    public NextStepDecorator() {
        this(null);
    }

    public NextStepDecorator(Throwable cause) {
        this.cause = cause;
    }

    public abstract boolean isOkayToContinueTest();

    public NextStepDecorator evaluate(CoreStep nextStep, Selenium selenium, TestState state) {
        return nextStep.execute(selenium, state);
    }

    public Throwable getCause() {
        return this.cause;
    }

    public static NextStepDecorator ERROR(Throwable cause) {
        return new NextStepDecorator(cause){

            @Override
            public boolean isOkayToContinueTest() {
                return false;
            }
        };
    }

    public static NextStepDecorator ASSERTION_FAILED(String message) {
        return new NextStepDecorator((Throwable)((Object)new AssertionError((Object)message))){

            @Override
            public boolean isOkayToContinueTest() {
                return false;
            }
        };
    }

    public static NextStepDecorator VERIFICATION_FAILED(String message) {
        return new NextStepDecorator((Throwable)((Object)new AssertionError((Object)message))){

            @Override
            public boolean isOkayToContinueTest() {
                return true;
            }
        };
    }
}

