/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.remote.tracing.DistributedTracer;
import org.openqa.selenium.remote.tracing.OpenTracingSpan;
import org.openqa.selenium.remote.tracing.Span;

class OpenTracingTracer
implements DistributedTracer {
    private final Tracer delegate;

    public OpenTracingTracer(Tracer delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public Span createSpan(String operation, Span parent) {
        SpanContext context = null;
        if (parent instanceof OpenTracingSpan) {
            context = ((OpenTracingSpan)parent).getContext();
        }
        io.opentracing.Span span = this.delegate.buildSpan(operation).asChildOf(context).start();
        this.delegate.scopeManager().activate(span, false);
        OpenTracingSpan toReturn = new OpenTracingSpan(this.delegate, span);
        toReturn.activate();
        return toReturn;
    }

    @Override
    public <C> Span createSpan(String operationName, C carrier, Function<C, Map<String, String>> extractor) {
        Map<String, String> map = extractor.apply(carrier);
        SpanContext context = this.delegate.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(map));
        io.opentracing.Span span = this.delegate.buildSpan(operationName).asChildOf(context).start();
        this.delegate.scopeManager().activate(span, false);
        OpenTracingSpan toReturn = new OpenTracingSpan(this.delegate, span);
        toReturn.activate();
        return toReturn;
    }

    @Override
    public Span getActiveSpan() {
        io.opentracing.Span span = this.delegate.activeSpan();
        return span == null ? null : new OpenTracingSpan(this.delegate, span);
    }

    public String toString() {
        return "OpenTracing(" + this.delegate.getClass().getSimpleName() + ")";
    }
}

