/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

public class AddCookie
extends WebDriverHandler<Void> {
    private volatile Map<String, Object> rawCookie;

    public AddCookie(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        super.setJsonParameters(allParameters);
        this.rawCookie = new HashMap<String, Object>((Map)allParameters.get("cookie"));
    }

    @Override
    public Void call() {
        Cookie cookie = this.createCookie();
        this.getDriver().manage().addCookie(cookie);
        return null;
    }

    protected Cookie createCookie() {
        if (this.rawCookie == null) {
            return null;
        }
        String name = (String)this.rawCookie.get("name");
        String value = (String)this.rawCookie.get("value");
        String path = (String)this.rawCookie.get("path");
        String domain = (String)this.rawCookie.get("domain");
        boolean secure = this.getBooleanFromRaw("secure");
        boolean httpOnly = this.getBooleanFromRaw("httpOnly");
        Number expiryNum = (Number)this.rawCookie.get("expiry");
        Date expiry = expiryNum == null ? null : new Date(TimeUnit.SECONDS.toMillis(expiryNum.longValue()));
        return new Cookie.Builder(name, value).path(path).domain(domain).isSecure(secure).expiresOn(expiry).isHttpOnly(httpOnly).build();
    }

    private boolean getBooleanFromRaw(String key) {
        if (this.rawCookie.containsKey(key)) {
            Object value = this.rawCookie.get(key);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return ((String)value).equalsIgnoreCase("true");
            }
        }
        return false;
    }

    public String toString() {
        return "[add cookie: " + this.createCookie() + "]";
    }
}

