/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.net.MediaType;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.ErrorCodec;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ErrorHandler
implements CommandHandler {
    private final Json json;
    private final Throwable throwable;
    private final ErrorCodec errors = ErrorCodec.createDefault();

    public ErrorHandler(Json json, Throwable throwable) {
        this.json = Objects.requireNonNull(json);
        this.throwable = Objects.requireNonNull(throwable);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) {
        resp.setHeader("Cache-Control", "none");
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setStatus(this.errors.getHttpStatusCode(this.throwable));
        resp.setContent(this.json.toJson(this.errors.encode(this.throwable)).getBytes(StandardCharsets.UTF_8));
    }
}

